/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Fuzzy;

import Catalano.Fuzzy.FuzzySet;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LinguisticVariable {
    private String name;
    private float start;
    private float end;
    private HashMap<String, FuzzySet> labels;
    private float numericInput;

    public LinguisticVariable(String name, float start, float end) {
        this.name = name;
        this.start = start;
        this.end = end;
        this.labels = new HashMap(10);
    }

    public float getNumericInput() {
        return this.numericInput;
    }

    public void setNumericInput(float numericInput) {
        this.numericInput = numericInput;
    }

    public String getName() {
        return this.name;
    }

    public float getStart() {
        return this.start;
    }

    public float getEnd() {
        return this.end;
    }

    public void addLabel(FuzzySet label) {
        if (this.labels.containsKey(label.Name())) {
            try {
                throw new Exception("The linguistic label name already exists in the linguistic variable.");
            }
            catch (Exception ex) {
                Logger.getLogger(LinguisticVariable.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (label.LeftLimit() < this.start) {
            try {
                throw new Exception("The left limit of the fuzzy set can not be lower than the linguistic variable's starting point.");
            }
            catch (Exception ex) {
                Logger.getLogger(LinguisticVariable.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (label.RightLimit() > this.end) {
            try {
                throw new Exception("The right limit of the fuzzy set can not be greater than the linguistic variable's ending point.");
            }
            catch (Exception ex) {
                Logger.getLogger(LinguisticVariable.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.labels.put(label.Name(), label);
    }

    public void ClearLabels() {
        this.labels.clear();
    }

    public FuzzySet getLabel(String labelName) {
        return this.labels.get(labelName);
    }

    public float GetLabelMembership(String labelName, float value) {
        FuzzySet fs = this.labels.get(labelName);
        return fs.getMembership(value);
    }
}

