/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Metaheuristics.Monoobjective;

import Catalano.Core.DoubleRange;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.BaseEvolutionaryOptimization;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.IObjectiveFunction;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.Individual;
import Catalano.Math.Matrix;
import Catalano.Math.Tools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class HarmonySearch
extends BaseEvolutionaryOptimization {
    private int newHarmonies;
    private double hmcr;
    private double pitch;
    private double fw;
    private double dampFactor;

    public int getNewHarmonies() {
        return this.newHarmonies;
    }

    public void setNewHarmonies(int newHarmonies) {
        this.newHarmonies = newHarmonies;
    }

    public double getHarmonyMemoryConsiderationRate() {
        return this.hmcr;
    }

    public void setHarmonyMemoryConsiderationRate(double hmcr) {
        this.hmcr = hmcr;
    }

    public double getPitch() {
        return this.pitch;
    }

    public void setPitch(double pitch) {
        this.pitch = pitch;
    }

    public double getFretWidth() {
        return this.fw;
    }

    public void setFretWidth(double fw) {
        this.fw = fw;
    }

    public double getDampFactor() {
        return this.dampFactor;
    }

    public void setDampFactor(double dampFactor) {
        this.dampFactor = dampFactor;
    }

    public HarmonySearch() {
        this(25, 1000);
    }

    public HarmonySearch(int population, int generations) {
        this(population, generations, 20);
    }

    public HarmonySearch(int population, int generations, int newHarmonies) {
        this(population, generations, newHarmonies, 0.9);
    }

    public HarmonySearch(int population, int generations, int newHarmonies, double hmcr) {
        this(population, generations, newHarmonies, hmcr, 0.1);
    }

    public HarmonySearch(int population, int generations, int newHarmonies, double hmcr, double pitch) {
        this(population, generations, newHarmonies, hmcr, pitch, 0.02);
    }

    public HarmonySearch(int population, int generations, int newHarmonies, double hmcr, double pitch, double fw) {
        this(population, generations, newHarmonies, hmcr, pitch, fw, 0.995);
    }

    public HarmonySearch(int population, int generations, int newHarmonies, double hmcr, double pitch, double fw, double dampFactor) {
        this.populationSize = population;
        this.generations = generations;
        this.newHarmonies = newHarmonies;
        this.hmcr = hmcr;
        this.pitch = pitch;
        this.fw = fw;
        this.dampFactor = dampFactor;
    }

    @Override
    public void Compute(IObjectiveFunction function, List<DoubleRange> boundConstraint) {
        this.minError = Double.MAX_VALUE;
        this.nEvals = 0L;
        Random rand = new Random();
        List<Individual> pop = Individual.CreatePopulation(this.populationSize, boundConstraint, function);
        Collections.sort(pop);
        double[] fretWidth = new double[boundConstraint.size()];
        for (int i = 0; i < fretWidth.length; ++i) {
            DoubleRange range = boundConstraint.get(i);
            fretWidth[i] = this.fw * (range.getMax() - range.getMin());
        }
        for (int g = 0; g < this.generations; ++g) {
            int i;
            ArrayList<Individual> newPop = new ArrayList<Individual>(this.newHarmonies);
            for (i = 0; i < this.newHarmonies; ++i) {
                double[] values = Matrix.UniformRandom(boundConstraint);
                newPop.add(new Individual(values));
            }
            for (i = 0; i < this.newHarmonies; ++i) {
                for (int j = 0; j < boundConstraint.size(); ++j) {
                    if (rand.nextDouble() <= this.hmcr) {
                        int randPos = rand.nextInt(pop.size());
                        ((Individual)newPop.get((int)i)).getLocation()[j] = pop.get(randPos).getLocation()[j];
                    }
                    double v = ((Individual)newPop.get(i)).getLocation()[j];
                    if (rand.nextDouble() <= this.pitch) {
                        v += rand.nextGaussian() * fretWidth[j];
                    }
                    ((Individual)newPop.get((int)i)).getLocation()[j] = Tools.Clamp(v, boundConstraint.get(j));
                }
                ((Individual)newPop.get(i)).setFitness(function.Compute(((Individual)newPop.get(i)).getLocation()));
                ++this.nEvals;
            }
            pop.addAll(newPop);
            Collections.sort(pop);
            pop = pop.subList(0, this.populationSize);
            i = 0;
            while (i < fretWidth.length) {
                int n = i++;
                fretWidth[n] = fretWidth[n] * this.dampFactor;
            }
            this.best = Arrays.copyOf(pop.get(0).getLocation(), boundConstraint.size());
            this.minError = pop.get(0).getFitness();
            if (this.listener == null) continue;
            this.listener.onIteration(g + 1, this.minError);
        }
    }

    @Override
    public double getError() {
        return this.minError;
    }
}

