/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Metaheuristics.Monoobjective;

import Catalano.Core.ArraysUtil;
import Catalano.Core.DoubleRange;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.BaseEvolutionaryOptimization;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.IObjectiveFunction;
import Catalano.Math.Matrix;
import Catalano.Math.Tools;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class ButterflyOptimizationAlgorithm
extends BaseEvolutionaryOptimization {
    private float pSwith;
    private double pExpoent;
    private double sensoryModality;

    public float getProbabilitySwith() {
        return this.pSwith;
    }

    public void setProbabilitySwith(float pSwith) {
        this.pSwith = pSwith;
    }

    public double getPowerExpoent() {
        return this.pExpoent;
    }

    public void setPowerExpoent(double pExpoent) {
        this.pExpoent = pExpoent;
    }

    public double getSensoryModality() {
        return this.sensoryModality;
    }

    public void setSensoryModality(double sensoryModality) {
        this.sensoryModality = sensoryModality;
    }

    public ButterflyOptimizationAlgorithm() {
    }

    public ButterflyOptimizationAlgorithm(int populationSize, int generations) {
        this(populationSize, generations, 0.8f, 0.1, 0.01);
    }

    public ButterflyOptimizationAlgorithm(int populationSize, int generations, float probabilitySwitch, double powerExpoent, double sensoryModality) {
        this.populationSize = populationSize;
        this.generations = generations;
        this.pSwith = probabilitySwitch;
        this.pExpoent = powerExpoent;
        this.sensoryModality = sensoryModality;
    }

    @Override
    public void Compute(IObjectiveFunction function, List<DoubleRange> bounds) {
        Random rand = new Random();
        this.minError = Double.MAX_VALUE;
        this.nEvals = 0L;
        double[][] pop = new double[this.populationSize][bounds.size()];
        double[] fitness = new double[this.populationSize];
        for (int i = 0; i < pop.length; ++i) {
            pop[i] = Matrix.UniformRandom(bounds);
            fitness[i] = function.Compute(pop[i]);
            if (!(fitness[i] < this.minError)) continue;
            this.minError = fitness[i];
            this.best = Arrays.copyOf(pop[i], pop[0].length);
        }
        this.nEvals += (long)this.populationSize;
        int[] index = Matrix.Indices(0, this.populationSize);
        for (int g = 0; g < this.generations; ++g) {
            for (int i = 0; i < pop.length; ++i) {
                int j;
                double r;
                double fp = this.sensoryModality * Math.pow(fitness[i], this.pExpoent);
                double[] s = new double[pop[0].length];
                if (rand.nextFloat() <= this.pSwith) {
                    r = rand.nextDouble();
                    for (j = 0; j < pop[0].length; ++j) {
                        s[j] = pop[i][j] + (r * r * this.best[j] - pop[i][j]) * fp;
                    }
                } else {
                    r = rand.nextDouble();
                    ArraysUtil.Shuffle(index);
                    for (j = 0; j < pop[0].length; ++j) {
                        s[j] = pop[i][j] + (r * r * pop[index[0]][j] - pop[index[1]][j]) * fp;
                    }
                }
                Tools.Clamp(s, bounds);
                double f = function.Compute(s);
                ++this.nEvals;
                if (f < fitness[i]) {
                    pop[i] = s;
                    fitness[i] = f;
                }
                if (!(f < this.minError)) continue;
                this.minError = f;
                this.best = Arrays.copyOf(pop[i], pop[0].length);
            }
            this.listener.onIteration(g + 1, this.minError);
            this.sensoryModality = this.NewSensoryModality(this.sensoryModality, g + 1);
        }
    }

    private double NewSensoryModality(double x, int gen) {
        return x + 0.025 / (x * (double)gen);
    }
}

