/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Genetic.Mutation;

import Catalano.Evolutionary.Genetic.Chromosome.DoubleChromosome;
import Catalano.Evolutionary.Genetic.Chromosome.FloatChromosome;
import Catalano.Evolutionary.Genetic.Chromosome.IChromosome;
import Catalano.Evolutionary.Genetic.Mutation.IMutation;
import Catalano.Math.Tools;
import java.util.Random;

public class MultiplierMutation
implements IMutation<IChromosome> {
    private float balancer;

    public double getBalancer() {
        return this.balancer;
    }

    public void setBalancer(float balancer) {
        this.balancer = balancer;
    }

    public MultiplierMutation() {
        this(0.5f);
    }

    public MultiplierMutation(float balancer) {
        this.balancer = balancer;
    }

    @Override
    public IChromosome Compute(IChromosome chromossome) {
        if (chromossome instanceof FloatChromosome) {
            return this.Compute((FloatChromosome)chromossome);
        }
        if (chromossome instanceof DoubleChromosome) {
            return this.Compute((DoubleChromosome)chromossome);
        }
        throw new IllegalArgumentException("Multiplier mutation only works with Double/Float chromosomes.");
    }

    @Override
    private IChromosome Compute(DoubleChromosome chromossome) {
        Random rand = new Random();
        DoubleChromosome c = (DoubleChromosome)chromossome.Clone();
        int gene = rand.nextInt(c.getLength());
        if (rand.nextDouble() < (double)this.balancer) {
            double value = (Double)chromossome.getGene(gene) * rand.nextDouble();
            value = Tools.Clamp(value, chromossome.getMinValue(), chromossome.getMaxValue());
            c.setGene(gene, (Object)value);
        } else {
            double value = (Double)chromossome.getGene(gene) + rand.nextDouble();
            value = Tools.Clamp(value, chromossome.getMinValue(), chromossome.getMaxValue());
            c.setGene(gene, (Object)value);
        }
        return c;
    }

    @Override
    private IChromosome Compute(FloatChromosome chromossome) {
        Random rand = new Random();
        FloatChromosome c = (FloatChromosome)chromossome.Clone();
        int gene = rand.nextInt(c.getLength());
        if (rand.nextDouble() < (double)this.balancer) {
            float value = ((Float)chromossome.getGene(gene)).floatValue() * rand.nextFloat();
            value = Tools.Clamp(value, chromossome.getMinValue(), chromossome.getMaxValue());
            c.setGene(gene, Float.valueOf(value));
        } else {
            float value = ((Float)chromossome.getGene(gene)).floatValue() + rand.nextFloat();
            value = Tools.Clamp(value, chromossome.getMinValue(), chromossome.getMaxValue());
            c.setGene(gene, Float.valueOf(value));
        }
        return c;
    }
}

