/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Genetic.Crossover;

import Catalano.Evolutionary.Genetic.Chromosome.DoubleChromosome;
import Catalano.Evolutionary.Genetic.Chromosome.FloatChromosome;
import Catalano.Evolutionary.Genetic.Chromosome.IChromosome;
import Catalano.Evolutionary.Genetic.Crossover.ICrossover;
import java.util.ArrayList;
import java.util.List;

public class LinearCrossover
implements ICrossover<IChromosome> {
    @Override
    public List<IChromosome> Compute(IChromosome chromosome1, IChromosome chromosome2) {
        if (chromosome1 instanceof FloatChromosome) {
            return this.Compute((FloatChromosome)chromosome1, (FloatChromosome)chromosome2);
        }
        if (chromosome1 instanceof DoubleChromosome) {
            return this.Compute((DoubleChromosome)chromosome1, (DoubleChromosome)chromosome2);
        }
        throw new IllegalArgumentException("Linear crossover only works with Double/Float chromosomes.");
    }

    @Override
    private List<IChromosome> Compute(DoubleChromosome chromosome1, DoubleChromosome chromosome2) {
        double[] c1 = new double[chromosome1.getLength()];
        double[] c2 = new double[chromosome1.getLength()];
        double[] c3 = new double[chromosome1.getLength()];
        for (int i = 0; i < c1.length; ++i) {
            c1[i] = 0.5 * (Double)chromosome1.getGene(i) + 0.5 * (Double)chromosome2.getGene(i);
            c2[i] = 1.5 * (Double)chromosome1.getGene(i) - 0.5 * (Double)chromosome2.getGene(i);
            c3[i] = -0.5 * (Double)chromosome1.getGene(i) + 1.5 * (Double)chromosome2.getGene(i);
        }
        ArrayList<IChromosome> list = new ArrayList<IChromosome>(3);
        list.add(new DoubleChromosome(c1, chromosome1.getMinValue(), chromosome1.getMaxValue()));
        list.add(new DoubleChromosome(c2, chromosome1.getMinValue(), chromosome1.getMaxValue()));
        list.add(new DoubleChromosome(c3, chromosome1.getMinValue(), chromosome1.getMaxValue()));
        return list;
    }

    @Override
    private List<IChromosome> Compute(FloatChromosome chromosome1, FloatChromosome chromosome2) {
        float[] c1 = new float[chromosome1.getLength()];
        float[] c2 = new float[chromosome1.getLength()];
        float[] c3 = new float[chromosome1.getLength()];
        for (int i = 0; i < c1.length; ++i) {
            c1[i] = 0.5f * ((Float)chromosome1.getGene(i)).floatValue() + 0.5f * ((Float)chromosome2.getGene(i)).floatValue();
            c2[i] = 1.5f * ((Float)chromosome1.getGene(i)).floatValue() - 0.5f * ((Float)chromosome2.getGene(i)).floatValue();
            c3[i] = -0.5f * ((Float)chromosome1.getGene(i)).floatValue() + 1.5f * ((Float)chromosome2.getGene(i)).floatValue();
        }
        ArrayList<IChromosome> list = new ArrayList<IChromosome>(3);
        list.add(new FloatChromosome(c1, chromosome1.getMinValue(), chromosome1.getMaxValue()));
        list.add(new FloatChromosome(c2, chromosome1.getMinValue(), chromosome1.getMaxValue()));
        list.add(new FloatChromosome(c3, chromosome1.getMinValue(), chromosome1.getMaxValue()));
        return list;
    }
}

