/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Genetic.Crossover;

import Catalano.Evolutionary.Genetic.Chromosome.IChromosome;
import Catalano.Evolutionary.Genetic.Chromosome.PermutationChromosome;
import Catalano.Evolutionary.Genetic.Crossover.ICrossover;
import java.util.ArrayList;
import java.util.List;

public class AlternatingPositionCrossover
implements ICrossover<IChromosome> {
    @Override
    public List<IChromosome> Compute(IChromosome chromosome1, IChromosome chromosome2) {
        if (chromosome1 instanceof PermutationChromosome) {
            throw new IllegalArgumentException("Alternating Position doesn't work with Permutation chromosome yet.");
        }
        int length = chromosome1.getLength();
        IChromosome c1 = chromosome1.Clone();
        IChromosome c2 = chromosome2.Clone();
        for (int i = 1; i < length; i += 2) {
            c1.setGene(i - 1, chromosome1.getGene(i - 1));
            c1.setGene(i, chromosome2.getGene(i));
            c2.setGene(i - 1, chromosome2.getGene(i - 1));
            c2.setGene(i, chromosome1.getGene(i));
        }
        ArrayList<IChromosome> lst = new ArrayList<IChromosome>(2);
        lst.add(c1);
        lst.add(c2);
        return lst;
    }
}

