/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Genetic.Chromosome;

import Catalano.Core.ArraysUtil;
import Catalano.Evolutionary.Genetic.Chromosome.ChromosomeBase;
import Catalano.Evolutionary.Genetic.Chromosome.IChromosome;
import Catalano.Math.Matrix;
import java.util.Arrays;

public class PermutationChromosome
extends ChromosomeBase {
    private int[] data;

    @Override
    public int getLength() {
        return this.data.length;
    }

    @Override
    public Object getGene(int index) {
        return this.data[index];
    }

    @Override
    public void setGene(int index, Object gene) {
        this.data[index] = (Integer)gene;
    }

    public int[] getData() {
        return this.data;
    }

    public PermutationChromosome(int lenght) {
        this.data = Matrix.Indices(0, lenght);
        ArraysUtil.Shuffle(this.data);
    }

    public PermutationChromosome(int[] data) {
        this.data = data;
    }

    @Override
    public void Generate() {
        this.data = Matrix.Indices(0, this.data.length);
        ArraysUtil.Shuffle(this.data);
    }

    @Override
    public IChromosome CreateNew() {
        return new PermutationChromosome(this.data.length);
    }

    @Override
    public IChromosome Clone() {
        PermutationChromosome pc = new PermutationChromosome(Arrays.copyOf(this.data, this.data.length));
        pc.fitness = this.fitness;
        return pc;
    }

    public String toString() {
        String str = "";
        for (int i = 0; i < this.data.length - 1; ++i) {
            str = str + String.valueOf(this.data[i]) + " ";
        }
        str = str + String.valueOf(this.data[this.data.length - 1]);
        return str;
    }
}

