/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Genetic.Chromosome;

import Catalano.Evolutionary.Genetic.Chromosome.ChromosomeBase;
import Catalano.Evolutionary.Genetic.Chromosome.IChromosome;
import Catalano.Math.Tools;
import java.util.Arrays;
import java.util.Random;

public class FloatChromosome
extends ChromosomeBase {
    private final int size;
    private float minValue;
    private float maxValue;
    private float[] values;

    public float getMinValue() {
        return this.minValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public float[] getData() {
        return this.values;
    }

    public FloatChromosome(float[] values, float minValue, float maxValue) {
        this.size = values.length;
        this.values = values;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public FloatChromosome(int size, float minValue, float maxValue) {
        this.size = size;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.Generate();
    }

    @Override
    public Object getGene(int index) {
        return Float.valueOf(this.values[index]);
    }

    @Override
    public void setGene(int index, Object gene) {
        this.values[index] = ((Float)gene).floatValue();
    }

    @Override
    public void Generate() {
        Random rand = new Random();
        this.values = new float[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.values[i] = Tools.Scale(0.0f, 1.0f, this.minValue, this.maxValue, rand.nextFloat());
        }
    }

    @Override
    public IChromosome CreateNew() {
        return new FloatChromosome(this.size, this.minValue, this.maxValue);
    }

    @Override
    public IChromosome Clone() {
        FloatChromosome c = new FloatChromosome(Arrays.copyOf(this.values, this.values.length), this.minValue, this.maxValue);
        c.fitness = this.fitness;
        return c;
    }

    @Override
    public int getLength() {
        return this.size;
    }

    public String toString() {
        String str = "";
        for (int i = 0; i < this.size; ++i) {
            str = str + String.valueOf(this.values[i]);
        }
        return str;
    }
}

