/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Genetic.Chromosome;

import Catalano.Evolutionary.Genetic.Chromosome.ChromosomeBase;
import Catalano.Evolutionary.Genetic.Chromosome.IChromosome;
import Catalano.Math.Tools;
import java.util.Arrays;
import java.util.Random;

public class DoubleChromosome
extends ChromosomeBase {
    private final int size;
    private double minValue;
    private double maxValue;
    private double[] values;

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double[] getData() {
        return this.values;
    }

    public DoubleChromosome(double[] values, double minValue, double maxValue) {
        this.size = values.length;
        this.values = values;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public DoubleChromosome(int size, double minValue, double maxValue) {
        this.size = size;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.Generate();
    }

    @Override
    public Object getGene(int index) {
        return this.values[index];
    }

    @Override
    public void setGene(int index, Object gene) {
        this.values[index] = (Double)gene;
    }

    @Override
    public void Generate() {
        Random rand = new Random();
        this.values = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.values[i] = Tools.Scale(0.0, 1.0, this.minValue, this.maxValue, rand.nextDouble());
        }
    }

    @Override
    public IChromosome CreateNew() {
        return new DoubleChromosome(this.size, this.minValue, this.maxValue);
    }

    @Override
    public IChromosome Clone() {
        DoubleChromosome c = new DoubleChromosome(Arrays.copyOf(this.values, this.values.length), this.minValue, this.maxValue);
        c.fitness = this.fitness;
        return c;
    }

    @Override
    public int getLength() {
        return this.size;
    }

    public String toString() {
        String str = "";
        for (int i = 0; i < this.size; ++i) {
            str = str + String.valueOf(this.values[i]);
        }
        return str;
    }
}

