/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Genetic.Chromosome;

import Catalano.Evolutionary.Genetic.Chromosome.ChromosomeBase;
import Catalano.Evolutionary.Genetic.Chromosome.IChromosome;
import java.math.BigInteger;
import java.util.Random;

public class BinaryChromosome
extends ChromosomeBase {
    private int nBits;
    private BigInteger data;

    @Override
    public int getLength() {
        return this.nBits;
    }

    public void setBinary(String bits) {
        this.data = new BigInteger(bits, 2);
    }

    @Override
    public Object getGene(int index) {
        String bin = this.toBinary();
        return Character.valueOf(bin.charAt(index));
    }

    @Override
    public void setGene(int index, Object gene) {
        String bin = this.toBinary();
        StringBuilder str = new StringBuilder(bin);
        str.setCharAt(index, ((Character)gene).charValue());
        this.data = new BigInteger(str.toString(), 2);
    }

    public BinaryChromosome(int nBits) {
        this.nBits = nBits;
        this.Generate();
    }

    public BinaryChromosome(int nBits, String bits) {
        this.nBits = nBits;
        this.data = new BigInteger(bits, 2);
    }

    @Override
    public void Generate() {
        Random r = new Random();
        String bin = "";
        for (int i = 0; i < this.nBits; ++i) {
            bin = bin + r.nextInt(2);
        }
        this.data = new BigInteger(bin, 2);
    }

    @Override
    public IChromosome CreateNew() {
        return new BinaryChromosome(this.nBits);
    }

    @Override
    public IChromosome Clone() {
        try {
            return (BinaryChromosome)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public String toBinary() {
        String v = this.data.toString(2);
        int rest = this.nBits - v.length();
        if (rest == 0) {
            return v;
        }
        String pad = "";
        for (int i = 0; i < rest; ++i) {
            pad = pad + "0";
        }
        return pad + v;
    }

    public String toString() {
        return this.toBinary();
    }
}

