/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit.util;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.webswing.component.HtmlPanelImpl;
import org.webswing.dispatch.WebPaintDispatcher;
import org.webswing.ext.services.ToolkitFXService;
import org.webswing.model.c2s.KeyboardEventMsgIn;
import org.webswing.model.c2s.MouseEventMsgIn;
import org.webswing.model.s2c.AppFrameMsgOut;
import org.webswing.model.s2c.FileDialogEventMsg;
import org.webswing.model.s2c.WindowMsg;
import org.webswing.model.s2c.WindowPartialContentMsg;
import org.webswing.model.s2c.WindowSwitchMsg;
import org.webswing.toolkit.WebComponentPeer;
import org.webswing.toolkit.WebToolkit;
import org.webswing.toolkit.WebWindowPeer;
import org.webswing.toolkit.api.component.Dockable;
import org.webswing.toolkit.api.component.HtmlPanel;
import org.webswing.toolkit.util.Logger;
import org.webswing.toolkit.util.Services;

public class Util {
    private static List<Integer> NO_CHAR_KEY_CODES = Arrays.asList(112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 154, 145, 19, 155, 36, 34, 35, 34, 20, 38, 37, 40, 39, 16, 17, 18, 524, 65406);
    private static Map<Integer, Character> CONTROL_MAP = new HashMap<Integer, Character>();

    public static File convertAndSaveCursor(BufferedImage img, int x, int y) {
        String tempDir = System.getProperty("webswing.tempDirPath");
        try {
            byte[] bytes = Util.convertToIco(img, x, y);
            int id = Arrays.hashCode(bytes);
            File f = new File(URI.create(tempDir + "/c" + id + ".cur"));
            if (!f.exists()) {
                FileOutputStream output = new FileOutputStream(f);
                output.write(bytes);
                output.close();
            }
            return f;
        }
        catch (Exception e) {
            Logger.error("Failed to save cursor to file.", e);
            return null;
        }
    }

    private static byte[] convertToIco(BufferedImage img, int hotspotx, int hotspoty) throws IOException {
        byte[] imgBytes = Services.getImageService().getPngImage(img);
        ByteBuffer bytes = ByteBuffer.allocate(imgBytes.length + 22);
        bytes.order(ByteOrder.LITTLE_ENDIAN);
        bytes.putShort((short)0);
        bytes.putShort((short)1);
        bytes.putShort((short)1);
        bytes.put((byte)img.getWidth());
        bytes.put((byte)img.getHeight());
        bytes.put((byte)img.getColorModel().getNumColorComponents());
        bytes.put((byte)0);
        bytes.putShort((short)hotspotx);
        bytes.putShort((short)hotspoty);
        bytes.putInt(imgBytes.length);
        bytes.putInt(22);
        bytes.put(imgBytes);
        return bytes.array();
    }

    public static int getMouseButtonsAWTFlag(int button) {
        switch (button) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 0: {
                return 0;
            }
        }
        return 0;
    }

    public static int getMouseModifiersAWTFlag(MouseEventMsgIn evt) {
        int result = 0;
        if ((evt.getButtons() & 2) == 2) {
            result |= 0x400;
        }
        if ((evt.getButtons() & 4) == 4) {
            result |= 0x800;
        }
        if ((evt.getButtons() & 8) == 8) {
            result |= 0x1000;
        }
        if (evt.isCtrl()) {
            result |= 0x80;
        }
        if (evt.isAlt()) {
            result |= 0x200;
        }
        if (evt.isShift()) {
            result |= 0x40;
        }
        if (evt.isMeta()) {
            result |= 0x100;
        }
        return result;
    }

    public static void savePngImage(BufferedImage imageContent, String name) {
        try {
            FileOutputStream os = new FileOutputStream(new File(name));
            ImageOutputStream ios = ImageIO.createImageOutputStream(os);
            ImageIO.write((RenderedImage)imageContent, "png", ios);
            ios.close();
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            Logger.error("Util:savePngImage", e);
        }
    }

    public static int getKeyModifiersAWTFlag(KeyboardEventMsgIn event) {
        int modifiers = 0;
        if (event.isAlt()) {
            modifiers |= 8;
        }
        if (event.isCtrl()) {
            modifiers |= 2;
        }
        if (event.isShift()) {
            modifiers |= 1;
        }
        if (event.isAltgr()) {
            modifiers |= 0x20;
        }
        if (event.isMeta()) {
            modifiers |= 4;
        }
        if (Util.getKeyType(event.getType()) == 400 && event.isAlt() && event.isCtrl() && !event.isShift() && !event.isMeta()) {
            modifiers = 32;
        }
        return modifiers;
    }

    public static int getKeyType(KeyboardEventMsgIn.KeyEventType type) {
        switch (type) {
            case keydown: {
                return 401;
            }
            case keypress: {
                return 400;
            }
            case keyup: {
                return 402;
            }
        }
        return 0;
    }

    public static char getKeyCharacter(KeyboardEventMsgIn event) {
        if (NO_CHAR_KEY_CODES.contains(event.getKeycode())) {
            return '\uffff';
        }
        if (event.isCtrl() && !event.isAlt() && !event.isMeta() && !event.isShift() && !event.isMeta() && CONTROL_MAP.containsKey(event.getKeycode())) {
            return CONTROL_MAP.get(event.getKeycode()).charValue();
        }
        return (char)event.getCharacter();
    }

    public static BufferedImage deepCopy(BufferedImage bi) {
        ColorModel cm = bi.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = bi.copyData(null);
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }

    public static Rectangle[] concatRectangleArrays(Rectangle[] A, Rectangle[] B) {
        int aLen = A.length;
        int bLen = B.length;
        Rectangle[] C = new Rectangle[aLen + bLen];
        System.arraycopy(A, 0, C, 0, aLen);
        System.arraycopy(B, 0, C, aLen, bLen);
        return C;
    }

    public static WebToolkit getWebToolkit() {
        return (WebToolkit)Toolkit.getDefaultToolkit();
    }

    public static WebWindowPeer findWindowPeerById(String id) {
        for (Window w : Window.getWindows()) {
            Object peer = WebToolkit.targetToPeer(w);
            if (peer == null || !(peer instanceof WebWindowPeer) || !((WebWindowPeer)peer).getGuid().equals(id)) continue;
            return (WebWindowPeer)peer;
        }
        return null;
    }

    public static Window findWindowById(String id) {
        for (Window w : Window.getWindows()) {
            Object peer = WebToolkit.targetToPeer(w);
            if (peer == null || !(peer instanceof WebWindowPeer) || !((WebWindowPeer)peer).getGuid().equals(id)) continue;
            return w;
        }
        return null;
    }

    public static HtmlPanel findHtmlPanelById(String id) {
        return Util.getWebToolkit().getPaintDispatcher().findHtmlPanelById(id);
    }

    public static WebComponentPeer getPeerForTarget(Object paramObject) {
        WebComponentPeer localWObjectPeer = (WebComponentPeer)WebToolkit.targetToPeer(paramObject);
        return localWObjectPeer;
    }

    public static Window[] getAllWindows() {
        ArrayList<Window> windows = new ArrayList<Window>(Arrays.asList(Window.getWindows()));
        Iterator i = windows.iterator();
        while (i.hasNext()) {
            Window w = (Window)i.next();
            if (!w.getClass().getName().contains("JLightweightFrame")) continue;
            i.remove();
        }
        return windows.toArray(new Window[windows.size()]);
    }

    public static Map<String, Map<Integer, BufferedImage>> extractWindowImages(AppFrameMsgOut json, Map<String, Map<Integer, BufferedImage>> windowImages) {
        for (WindowMsg window : json.getWindows()) {
            WebWindowPeer w = Util.findWindowPeerById(window.getId());
            if (window.getId().equals("BG")) {
                windowImages.put(window.getId(), new HashMap());
                continue;
            }
            HashMap<Integer, BufferedImage> imageMap = new HashMap<Integer, BufferedImage>();
            for (int i = 0; i < window.getContent().size(); ++i) {
                WindowPartialContentMsg wpc = window.getContent().get(i);
                imageMap.put(i, w.extractBufferedImage(new Rectangle(wpc.getPositionX(), wpc.getPositionY(), wpc.getWidth(), wpc.getHeight())));
            }
            windowImages.put(window.getId(), imageMap);
        }
        return windowImages;
    }

    public static Map<String, Image> extractWindowWebImages(Set<String> updatedWindows, Map<String, Image> webImages) {
        for (String windowId : updatedWindows) {
            WebWindowPeer w;
            if (windowId.equals("BG") || (w = Util.findWindowPeerById(windowId)) == null) continue;
            Image webimage = w.extractWebImage();
            webImages.put(windowId, webimage);
        }
        return webImages;
    }

    public static void encodeWindowImages(Map<String, Map<Integer, BufferedImage>> windowImages, AppFrameMsgOut json) {
        for (WindowMsg window : json.getWindows()) {
            if (window.getId().equals("BG")) continue;
            Map<Integer, BufferedImage> imageMap = windowImages.get(window.getId());
            for (int i = 0; i < window.getContent().size(); ++i) {
                WindowPartialContentMsg c = window.getContent().get(i);
                if (!imageMap.containsKey(i)) continue;
                c.setBase64Content(Services.getImageService().getPngImage(imageMap.get(i)));
            }
        }
    }

    public static void encodeWindowWebImages(Map<String, Image> windowWebImages, AppFrameMsgOut json) {
        for (WindowMsg window : json.getWindows()) {
            Image wi = windowWebImages.get(window.getId());
            if (wi == null) continue;
            window.setDirectDraw(Services.getDirectDrawService().buildWebImage(wi));
        }
    }

    public static AppFrameMsgOut fillWithWindowsData(Map<String, Set<Rectangle>> currentAreasToUpdate) {
        Map<String, List<Rectangle>> windowNonVisibleAreas = Util.getWebToolkit().getWindowManager().extractNonVisibleAreas();
        AppFrameMsgOut json = new AppFrameMsgOut();
        for (String windowId : currentAreasToUpdate.keySet()) {
            WebWindowPeer ww = Util.findWindowPeerById(windowId);
            if (ww == null && !windowId.equals("BG")) continue;
            WindowMsg window = json.getOrCreateWindowById(windowId);
            if (windowId.equals("BG")) {
                window.setPosX(0);
                window.setPosY(0);
                window.setWidth(Util.getWebToolkit().getScreenSize().width);
                window.setHeight(Util.getWebToolkit().getScreenSize().height);
            } else {
                Point location = ww.getLocationOnScreen();
                window.setPosX(location.x);
                window.setPosY(location.y);
                window.setWidth(ww.getBounds().width);
                window.setHeight(ww.getBounds().height);
                if (ww.getTarget() instanceof Frame) {
                    window.setTitle(((Frame)ww.getTarget()).getTitle());
                }
                if (ww.getTarget() instanceof Component) {
                    window.setName(((Component)ww.getTarget()).getName());
                }
            }
            List<Rectangle> toPaint = Util.joinRectangles(Util.getGrid(new ArrayList<Rectangle>((Collection)currentAreasToUpdate.get(windowId)), windowNonVisibleAreas.get(windowId)));
            Util.createPartialContentMsgs(window, toPaint);
        }
        return json;
    }

    public static AppFrameMsgOut fillWithCompositingWindowsData(Map<String, Set<Rectangle>> currentAreasToUpdate) {
        AppFrameMsgOut frame = new AppFrameMsgOut();
        List<String> zOrder = Util.getWebToolkit().getWindowManager().getZOrder();
        Map<Window, List<Container>> webContainers = Util.getWebToolkit().getPaintDispatcher().getRegisteredWebContainersAsMap();
        Map<Window, List<HtmlPanel>> htmlPanels = Util.getWebToolkit().getPaintDispatcher().getRegisteredHtmlPanelsAsMap();
        HashMap<Container, Map<JComponent, WindowMsg>> htmlWebComponentsMap = new HashMap<Container, Map<JComponent, WindowMsg>>();
        for (String windowId : zOrder) {
            WebWindowPeer ww = Util.findWindowPeerById(windowId);
            if (ww == null) continue;
            WindowMsg window = new WindowMsg();
            window.setId(windowId);
            Point location = ww.getLocationOnScreen();
            window.setBounds(location.x, location.y, ww.getBounds().width, ww.getBounds().height);
            if (ww.getTarget() instanceof Frame) {
                window.setTitle(((Frame)ww.getTarget()).getTitle());
                window.setState(((Frame)ww.getTarget()).getExtendedState());
            }
            if (ww.getTarget() instanceof Component) {
                window.setName(((Component)ww.getTarget()).getName());
            }
            Util.fillClassType(ww.getTarget(), window);
            Util.fillDockMode(ww.getTarget(), window);
            window.setDockState(ww.isUndocked() ? WindowMsg.DockState.undocked : WindowMsg.DockState.docked);
            boolean modalBlocked = ww.getTarget() instanceof Window && Util.getWebToolkit().getWindowManager().isBlockedByModality((Window)ww.getTarget(), false);
            window.setModalBlocked(modalBlocked);
            if (!Util.isDD()) {
                Set<Rectangle> rects = currentAreasToUpdate.get(window.getId());
                window.setContent(Collections.emptyList());
                if (rects != null) {
                    List<Rectangle> toPaint = Util.joinRectangles(Util.getGrid(new ArrayList<Rectangle>(rects), null));
                    Util.createPartialContentMsgs(window, toPaint);
                }
            }
            if (ww.getTarget() instanceof Window) {
                window.setOwnerId(Util.findWindowOwner(((Window)ww.getTarget()).getOwner(), zOrder));
            }
            if (htmlPanels.containsKey(ww.getTarget())) {
                Util.handleHtmlPanels(htmlPanels, ww, window, frame, htmlWebComponentsMap);
            }
            if (webContainers.containsKey(ww.getTarget())) {
                Util.handleWebContainers(webContainers.get(ww.getTarget()), window, frame, htmlWebComponentsMap);
            }
            frame.getWindows().add(window);
        }
        return frame;
    }

    private static void createPartialContentMsgs(WindowMsg window, List<Rectangle> toPaint) {
        ArrayList<WindowPartialContentMsg> partialContentList = new ArrayList<WindowPartialContentMsg>();
        for (Rectangle r : toPaint) {
            if (r.x >= window.getWidth() || r.y >= window.getHeight()) continue;
            WindowPartialContentMsg content = new WindowPartialContentMsg(r.x, r.y, Math.min(r.width, window.getWidth() - r.x), Math.min(r.height, window.getHeight() - r.y));
            partialContentList.add(content);
        }
        window.setContent(partialContentList);
    }

    private static void handleHtmlPanels(Map<Window, List<HtmlPanel>> htmlPanels, WebWindowPeer ww, WindowMsg window, AppFrameMsgOut frame, Map<Container, Map<JComponent, WindowMsg>> htmlWebComponentsMap) {
        for (HtmlPanel htmlPanel : htmlPanels.get(ww.getTarget())) {
            if (!htmlPanel.isShowing()) continue;
            WindowMsg htmlWin = new WindowMsg(System.identityHashCode(htmlPanel) + "", htmlPanel.getName(), htmlPanel.getLocationOnScreen(), htmlPanel.getBounds().width, htmlPanel.getBounds().height, WindowMsg.WindowType.html, window.isModalBlocked(), window.getId());
            if (!Util.isDD()) {
                htmlWin.setContent(Collections.emptyList());
            }
            if (htmlPanel instanceof HtmlPanelImpl) {
                Container container = ((HtmlPanelImpl)htmlPanel).getWebContainer();
                JComponent component = ((HtmlPanelImpl)htmlPanel).getWebComponent();
                if (container != null && component != null) {
                    if (!htmlWebComponentsMap.containsKey(container)) {
                        htmlWebComponentsMap.put(container, new HashMap());
                    }
                    htmlWebComponentsMap.get(container).put(component, htmlWin);
                    continue;
                }
            }
            frame.getWindows().add(htmlWin);
        }
    }

    private static void handleWebContainers(List<Container> containers, WindowMsg window, AppFrameMsgOut frame, Map<Container, Map<JComponent, WindowMsg>> htmlWebComponentsMap) {
        Collections.sort(containers, (o1, o2) -> o1.isAncestorOf((Component)o2) ? 1 : (o2.isAncestorOf((Component)o1) ? -1 : 0));
        for (Container container : containers) {
            if (!container.isShowing()) continue;
            WindowMsg containerWin = new WindowMsg(System.identityHashCode(container) + "", container.getName(), container.getLocationOnScreen(), container.getBounds().width, container.getBounds().height, WindowMsg.WindowType.internalWrapper, window.isModalBlocked(), window.getId());
            if (!Util.isDD()) {
                containerWin.setContent(Collections.emptyList());
            }
            if (window.getInternalWindows() == null) {
                window.setInternalWindows(new ArrayList<WindowMsg>());
            }
            window.getInternalWindows().add(containerWin);
            Map<JComponent, WindowMsg> htmlComponents = htmlWebComponentsMap.get(container);
            for (Component c : container.getComponents()) {
                if (!c.isShowing()) continue;
                if (htmlComponents != null && htmlComponents.containsKey(c)) {
                    WindowMsg htmlWin = htmlComponents.get(c);
                    htmlWin.setOwnerId(containerWin.getId());
                    htmlWin.setType(WindowMsg.WindowType.internalHtml);
                    window.getInternalWindows().add(htmlWin);
                }
                WindowMsg componentWin = new WindowMsg(System.identityHashCode(c) + "", c.getName(), c.getLocationOnScreen(), c.getBounds().width, c.getBounds().height, WindowMsg.WindowType.internal, containerWin.isModalBlocked(), containerWin.getId());
                if (!Util.isDD()) {
                    componentWin.setContent(Collections.emptyList());
                }
                window.getInternalWindows().add(componentWin);
            }
        }
    }

    private static void fillClassType(Object windowTarget, WindowMsg window) {
        if (windowTarget instanceof JFrame) {
            window.setClassType(WindowMsg.WindowClassType.JFrame);
            return;
        }
        if (windowTarget instanceof JDialog) {
            window.setClassType(WindowMsg.WindowClassType.JDialog);
            return;
        }
        if (windowTarget instanceof JWindow) {
            window.setClassType(WindowMsg.WindowClassType.JWindow);
            return;
        }
        if (windowTarget instanceof Frame) {
            window.setClassType(WindowMsg.WindowClassType.Frame);
            return;
        }
        if (windowTarget instanceof Dialog) {
            window.setClassType(WindowMsg.WindowClassType.Dialog);
            return;
        }
        if (windowTarget instanceof Window) {
            window.setClassType(WindowMsg.WindowClassType.Window);
            return;
        }
    }

    private static void fillDockMode(Object windowTarget, WindowMsg window) {
        if (!(windowTarget instanceof Window)) {
            window.setDockMode(WindowMsg.DockMode.none);
            return;
        }
        if (windowTarget instanceof JWindow) {
            window.setDockMode(WindowMsg.DockMode.none);
            return;
        }
        switch (Util.getDockMode()) {
            case "ALL": {
                if (windowTarget instanceof Dockable) {
                    window.setDockMode(((Dockable)windowTarget).isAutoUndock() ? WindowMsg.DockMode.autoUndock : WindowMsg.DockMode.dockable);
                    break;
                }
                window.setDockMode(WindowMsg.DockMode.dockable);
                break;
            }
            case "MARKED": {
                if (!(windowTarget instanceof Dockable)) break;
                window.setDockMode(((Dockable)windowTarget).isAutoUndock() ? WindowMsg.DockMode.autoUndock : WindowMsg.DockMode.dockable);
                break;
            }
            case "NONE": {
                window.setDockMode(WindowMsg.DockMode.none);
            }
        }
    }

    private static String findWindowOwner(Window owner, List<String> zOrder) {
        if (owner == null) {
            return null;
        }
        WebWindowPeer peer = (WebWindowPeer)WebToolkit.targetToPeer(owner);
        if (peer != null && zOrder.contains(peer.getGuid())) {
            return peer.getGuid();
        }
        return null;
    }

    public static Map<String, Set<Rectangle>> postponeNonShowingAreas(Map<String, Set<Rectangle>> currentAreasToUpdate) {
        HashMap<String, Set<Rectangle>> forLaterProcessing = new HashMap<String, Set<Rectangle>>();
        for (String windowId : currentAreasToUpdate.keySet()) {
            WebWindowPeer ww = Util.findWindowPeerById(windowId);
            if (ww == null || ((Window)ww.getTarget()).isShowing()) continue;
            forLaterProcessing.put(windowId, currentAreasToUpdate.get(windowId));
        }
        for (String later : forLaterProcessing.keySet()) {
            currentAreasToUpdate.remove(later);
        }
        return forLaterProcessing;
    }

    public static boolean isWindowDecorationEvent(Window w, AWTEvent e) {
        if (e instanceof MouseEvent && 507 != e.getID() && w != null && w.isEnabled() && w.isShowing()) {
            return Util.isWindowDecorationPosition(w, new Point(((MouseEvent)e).getXOnScreen(), ((MouseEvent)e).getYOnScreen()));
        }
        return false;
    }

    public static boolean isWindowDecorationPosition(Window w, Point locationOnScreen) {
        if (w != null && locationOnScreen != null) {
            Rectangle inner = w.getBounds();
            Insets i = w.getInsets();
            inner.x = i.left;
            inner.y = i.top;
            inner.width -= i.left + i.right;
            inner.height -= i.top + i.bottom;
            boolean isInInnerWindow = SwingUtilities.isRectangleContainingRectangle(inner, new Rectangle(locationOnScreen.x - w.getX(), locationOnScreen.y - w.getY(), 0, 0));
            boolean isInWindow = SwingUtilities.isRectangleContainingRectangle(w.getBounds(), new Rectangle(locationOnScreen.x, locationOnScreen.y, 0, 0));
            return !isInInnerWindow && isInWindow;
        }
        return false;
    }

    public static Set<Rectangle> getGrid(List<Rectangle> dirtyAreas, List<Rectangle> topWindows) {
        HashSet<Rectangle> result = new HashSet<Rectangle>();
        TreeSet<Integer> xLines = new TreeSet<Integer>();
        TreeSet<Integer> yLines = new TreeSet<Integer>();
        for (Rectangle r : dirtyAreas) {
            xLines.add(r.x);
            xLines.add(r.x + r.width);
            yLines.add(r.y);
            yLines.add(r.y + r.height);
        }
        if (topWindows != null) {
            for (Rectangle r : topWindows) {
                xLines.add(r.x);
                xLines.add(r.x + r.width);
                yLines.add(r.y);
                yLines.add(r.y + r.height);
            }
        }
        Integer[] y = yLines.toArray(new Integer[yLines.size()]);
        Integer[] x = xLines.toArray(new Integer[xLines.size()]);
        for (int row = 0; row < y.length - 1; ++row) {
            for (int col = 0; col < x.length - 1; ++col) {
                Rectangle potential = new Rectangle(x[col], y[row], x[col + 1] - x[col], y[row + 1] - y[row]);
                boolean insideDirtyAreas = false;
                for (Rectangle da : dirtyAreas) {
                    if (!SwingUtilities.isRectangleContainingRectangle(da, potential)) continue;
                    insideDirtyAreas = true;
                    break;
                }
                if (!insideDirtyAreas) continue;
                boolean insideTopWindow = false;
                if (topWindows != null) {
                    for (Rectangle tw : topWindows) {
                        if (!SwingUtilities.isRectangleContainingRectangle(tw, potential)) continue;
                        insideTopWindow = true;
                        break;
                    }
                }
                if (insideTopWindow) continue;
                result.add(potential);
            }
        }
        return result;
    }

    public static List<Rectangle> joinRectangles(Set<Rectangle> grid) {
        ArrayList<Rectangle> result = new ArrayList<Rectangle>();
        ArrayList<Rectangle> gridList = new ArrayList<Rectangle>(grid);
        ArrayList<Rectangle> joinedRows = new ArrayList<Rectangle>();
        Collections.sort(gridList, new Comparator<Rectangle>(){

            @Override
            public int compare(Rectangle o1, Rectangle o2) {
                if (o1.y > o2.y) {
                    return 1;
                }
                if (o1.y == o2.y) {
                    if (o1.x > o2.x) {
                        return 1;
                    }
                    return -1;
                }
                return -1;
            }
        });
        Rectangle current = null;
        for (Rectangle r : gridList) {
            if (current == null) {
                current = r;
                continue;
            }
            if (current.y == r.y && current.height == r.height && current.x + current.width == r.x) {
                current.width += r.width;
                continue;
            }
            joinedRows.add(current);
            current = r;
        }
        if (current != null) {
            joinedRows.add(current);
        }
        Collections.sort(joinedRows, new Comparator<Rectangle>(){

            @Override
            public int compare(Rectangle o1, Rectangle o2) {
                if (o1.x > o2.x) {
                    return 1;
                }
                if (o1.x == o2.x) {
                    if (o1.y > o2.y) {
                        return 1;
                    }
                    return -1;
                }
                return -1;
            }
        });
        Rectangle currentX = null;
        for (Rectangle r : joinedRows) {
            if (currentX == null) {
                currentX = r;
                continue;
            }
            if (currentX.x == r.x && currentX.width == r.width && currentX.y + currentX.height == r.y) {
                currentX.height += r.height;
                continue;
            }
            result.add(currentX);
            currentX = r;
        }
        if (currentX != null) {
            result.add(currentX);
        }
        return result;
    }

    public static void resetWindowsGC(int width, int height) {
        ArrayList<Window> windows = new ArrayList<Window>(Arrays.asList(Window.getWindows()));
        for (Window w : windows) {
            try {
                Class<?> windowClazz;
                for (windowClazz = w.getClass(); windowClazz != Window.class && windowClazz != null; windowClazz = windowClazz.getSuperclass()) {
                }
                if (windowClazz != null) {
                    try {
                        Method m = windowClazz.getDeclaredMethod("resetGC", new Class[0]);
                        m.setAccessible(true);
                        m.invoke((Object)w, new Object[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                RepaintManager.currentManager(w).setDoubleBufferMaximumSize(new Dimension(width, height));
            }
            catch (Exception e) {
                Logger.error("Util:resetWindowsGC", e);
            }
        }
    }

    public static JFileChooser discoverFileChooser(WebWindowPeer windowPeer) {
        Window w = (Window)windowPeer.getTarget();
        return Util.discoverFileChooser(w);
    }

    public static JFileChooser discoverFileChooser(Window w) {
        Component[] coms;
        Container pane;
        if (w instanceof JDialog && (pane = ((JDialog)w).getContentPane()) != null && (coms = pane.getComponents()) != null && coms.length > 0 && coms[0] instanceof JFileChooser) {
            JFileChooser chooser = (JFileChooser)coms[0];
            chooser.putClientProperty("webswing.customFileChooser", false);
            return chooser;
        }
        return Util.getWebToolkit().getPaintDispatcher().findRegisteredFileChooser(w);
    }

    public static String resolveUploadFilename(File currentDir, String fileName) {
        if (!Util.existsFilename(currentDir, fileName)) {
            return fileName;
        }
        int i = fileName.lastIndexOf(46);
        String base = i > 0 ? fileName.substring(0, i) : fileName;
        String ext = i > 0 ? fileName.substring(i) : null;
        int next = 1;
        String nextFN;
        while (Util.existsFilename(currentDir, nextFN = base + " " + next + ext)) {
            ++next;
        }
        return nextFN;
    }

    public static boolean existsFilename(File currentDir, String fileName) {
        if (currentDir != null && currentDir.exists() && currentDir.isDirectory()) {
            for (File f : currentDir.listFiles()) {
                if (!f.getName().equals(fileName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDD() {
        boolean startDD = Boolean.valueOf(System.getProperty("webswing.directdraw", "false"));
        boolean supportedDD = Boolean.valueOf(System.getProperty("webswing.directdraw.supported", "true"));
        return startDD && supportedDD;
    }

    public static boolean isCompositingWM() {
        return Boolean.valueOf(System.getProperty("webswing.compositingWindowManager", "false"));
    }

    public static boolean isTestMode() {
        return Boolean.valueOf(System.getProperty("webswing.testMode", "false"));
    }

    public static String getDockMode() {
        if (Util.isTouchMode() || !Util.isCompositingWM()) {
            return "NONE";
        }
        return System.getProperty("webswing.dockMode", "NONE");
    }

    public static boolean isWindowUndocked(Window window) {
        WebWindowPeer peer = (WebWindowPeer)WebToolkit.targetToPeer(window);
        if (peer == null) {
            throw new IllegalArgumentException("Cannot find web window peer!");
        }
        return peer.isUndocked();
    }

    public static void toggleWindowDock(Window window, boolean undock) {
        WebWindowPeer peer = (WebWindowPeer)WebToolkit.targetToPeer(window);
        if (peer == null) {
            throw new IllegalArgumentException("Cannot find web window peer!");
        }
        peer.setUndocked(undock);
    }

    public static boolean isTouchMode() {
        return Boolean.valueOf(System.getProperty("webswing.touchMode", "false"));
    }

    public static boolean isAccessibilityEnabled() {
        return Boolean.valueOf(System.getProperty("webswing.accessibilityEnabled", "false"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void repaintAllWindow() {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            for (Window w : Util.getAllWindows()) {
                Object peer;
                if (!w.isShowing() || (peer = WebToolkit.targetToPeer(w)) == null || !(peer instanceof WebWindowPeer)) continue;
                ((WebWindowPeer)peer).updateWindowDecorationImage();
                RepaintManager.currentManager(null).addDirtyRegion(w, 0, 0, w.getWidth(), w.getHeight());
            }
        }
    }

    public static Panel findHwComponentParent(JComponent c) {
        for (Container p = c.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof Panel) || p instanceof Applet) continue;
            return (Panel)p;
        }
        return null;
    }

    public static AWTEvent createKeyEvent(Component src, int type, long when, int modifiers, int keycode, char character, int keyLocationStandard) {
        KeyEvent e = new KeyEvent(src, type, when, modifiers, keycode, character, 1);
        try {
            Field f = KeyEvent.class.getDeclaredField("extendedKeyCode");
            f.setAccessible(true);
            f.set(e, keycode);
        }
        catch (Exception e1) {
            Logger.error("Failed to update extendedKeyCode of KeyEvent", e);
        }
        return e;
    }

    public static FileDialogEventMsg.FileDialogEventType getFileChooserEventType(JFileChooser fileChooserDialog) {
        if (Boolean.getBoolean("webswing.isolatedFs")) {
            if (Boolean.TRUE.equals(fileChooserDialog.getClientProperty("webswing.customFileChooser")) || fileChooserDialog.getClientProperty("webswing.allowDelete") != null || fileChooserDialog.getClientProperty("webswing.allowUpload") != null || fileChooserDialog.getClientProperty("webswing.allowDownload") != null) {
                return FileDialogEventMsg.FileDialogEventType.Open;
            }
            if (Boolean.getBoolean("webswing.transparentFileOpen") && fileChooserDialog.getDialogType() == 0) {
                return FileDialogEventMsg.FileDialogEventType.AutoUpload;
            }
            if (Boolean.getBoolean("webswing.transparentFileSave") && fileChooserDialog.getDialogType() == 1) {
                return FileDialogEventMsg.FileDialogEventType.AutoSave;
            }
        }
        return FileDialogEventMsg.FileDialogEventType.Open;
    }

    public static String getFileChooserSelection(JFileChooser fileChooserDialog) {
        StringBuilder sb = new StringBuilder();
        if (fileChooserDialog.isMultiSelectionEnabled()) {
            if (fileChooserDialog.getSelectedFiles() != null) {
                for (File f : fileChooserDialog.getSelectedFiles()) {
                    sb.append(f.getName()).append(",");
                }
                return sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "";
            }
        } else if (fileChooserDialog.getSelectedFile() != null) {
            return fileChooserDialog.getSelectedFile().getName();
        }
        return "";
    }

    public static WebComponentPeer getPeer(Component comp) {
        if (comp == null) {
            return null;
        }
        try {
            Field peer = Component.class.getDeclaredField("peer");
            peer.setAccessible(true);
            return (WebComponentPeer)peer.get(comp);
        }
        catch (Exception e) {
            Logger.error("Failed to read peer of component " + comp, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForImage(Image i) {
        ImageObserver observer;
        Graphics imageLoaderG = new BufferedImage(1, 1, 1).getGraphics();
        ImageObserver imageObserver = observer = new ImageObserver(){

            @Override
            public synchronized boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                if ((infoflags & 0x20) == 32 || (infoflags & 0x10) == 16) {
                    this.notifyAll();
                }
                return true;
            }
        };
        synchronized (imageObserver) {
            if (!imageLoaderG.drawImage(i, 0, 0, observer)) {
                try {
                    observer.wait(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public static File getTimestampedTransferFolder(String marker) {
        String path = System.getProperty("webswing.transfer.dir", System.getProperty("user.dir") + "/upload");
        path = path.split(File.pathSeparator)[0];
        File timestampFoleder = new File(path, marker + System.currentTimeMillis());
        timestampFoleder.mkdirs();
        return timestampFoleder;
    }

    public static void resetWindowsPosition(int oldWidht, int oldHeight) {
        for (Window w : Util.getAllWindows()) {
            WebWindowPeer peer = (WebWindowPeer)WebToolkit.targetToPeer(w);
            if (peer == null) continue;
            Dimension current = Util.getWebToolkit().getScreenSize();
            if (peer.getTarget() instanceof JFrame) {
                JFrame frame = (JFrame)peer.getTarget();
                if (frame.getExtendedState() != 6 || Util.isCompositingWM()) continue;
                w.setLocation(0, 0);
                w.setBounds(0, 0, current.width, current.height);
                continue;
            }
            Rectangle b = w.getBounds();
            peer.setBounds(b.x, b.y, b.width, b.height, 0);
        }
    }

    public static boolean isFXWindow(Window w) {
        ToolkitFXService toolkitFXService = Services.getToolkitFXService();
        if (toolkitFXService == null) {
            return false;
        }
        return toolkitFXService.isFXWindow(w);
    }

    public static <T extends Component> Map<Window, List<T>> toWindowMapSynced(Set<T> componentSet) {
        HashMap<Window, List<T>> map = new HashMap<Window, List<T>>();
        Set<T> keys = componentSet;
        for (Component key : keys) {
            Window win = SwingUtilities.getWindowAncestor(key);
            if (!map.containsKey(win)) {
                map.put(win, new ArrayList());
            }
            ((List)map.get(win)).add(key);
        }
        return map;
    }

    public static <T> T instantiateClass(Class<T> ifc, String classNameProp, String fallbackClassName) {
        return Util.instantiateClass(ifc, classNameProp, fallbackClassName, null);
    }

    public static <T> T instantiateClass(Class<T> ifc, String classNameProp, String fallbackClassName, ClassLoader cl) {
        String implClassName = System.getProperty(classNameProp, fallbackClassName);
        if (cl == null) {
            cl = ifc.getClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        Class<?> implclass = null;
        try {
            implclass = cl.loadClass(implClassName);
        }
        catch (ClassNotFoundException e) {
            Logger.error(ifc.getSimpleName() + ": Implementation class not found", e);
            try {
                implclass = cl.loadClass(fallbackClassName);
            }
            catch (ClassNotFoundException e1) {
                Logger.fatal(ifc.getSimpleName() + ": Fatal error:Default implementation class not found.", e1);
                return null;
            }
        }
        if (ifc.isAssignableFrom(implclass)) {
            try {
                return (T)implclass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                Logger.fatal(ifc.getSimpleName() + ": exception when creating instance of " + implclass.getCanonicalName(), e);
            }
        } else {
            Logger.fatal(ifc.getSimpleName() + ": Fatal error: Implementation is not assignable to base class:" + implclass.getCanonicalName(), new Object[0]);
        }
        return null;
    }

    public static List<WindowSwitchMsg> getWindowSwitchList() {
        ArrayList<WindowSwitchMsg> list = new ArrayList<WindowSwitchMsg>();
        List<String> zOrder = Util.getWebToolkit().getWindowManager().getZOrder();
        for (String windowId : zOrder) {
            WebWindowPeer ww = Util.findWindowPeerById(windowId);
            if (ww == null) continue;
            WindowSwitchMsg window = new WindowSwitchMsg();
            window.setId(windowId);
            if (ww.getTarget() instanceof Frame) {
                window.setTitle(((Frame)ww.getTarget()).getTitle());
            } else if (ww.getTarget() instanceof Dialog) {
                window.setTitle(((Dialog)ww.getTarget()).getTitle());
            }
            window.setModalBlocked(ww.getTarget() instanceof Window && Util.getWebToolkit().getWindowManager().isBlockedByModality((Window)ww.getTarget(), false));
            list.add(window);
        }
        return list;
    }

    static {
        CONTROL_MAP.put(81, Character.valueOf('\u0011'));
        CONTROL_MAP.put(69, Character.valueOf('\u0005'));
        CONTROL_MAP.put(82, Character.valueOf('\u0012'));
        CONTROL_MAP.put(89, Character.valueOf('\u0019'));
        CONTROL_MAP.put(85, Character.valueOf('\u0015'));
        CONTROL_MAP.put(73, Character.valueOf('\t'));
        CONTROL_MAP.put(79, Character.valueOf('\u000f'));
        CONTROL_MAP.put(80, Character.valueOf('\u0010'));
        CONTROL_MAP.put(65, Character.valueOf('\u0001'));
        CONTROL_MAP.put(83, Character.valueOf('\u0013'));
        CONTROL_MAP.put(68, Character.valueOf('\u0004'));
        CONTROL_MAP.put(71, Character.valueOf('\u0007'));
        CONTROL_MAP.put(72, Character.valueOf('\b'));
        CONTROL_MAP.put(74, Character.valueOf('\n'));
        CONTROL_MAP.put(76, Character.valueOf('\f'));
        CONTROL_MAP.put(90, Character.valueOf('\u001a'));
        CONTROL_MAP.put(88, Character.valueOf('\u0018'));
        CONTROL_MAP.put(67, Character.valueOf('\u0003'));
        CONTROL_MAP.put(86, Character.valueOf('\u0016'));
        CONTROL_MAP.put(66, Character.valueOf('\u0002'));
        CONTROL_MAP.put(77, Character.valueOf('\r'));
    }
}

