/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit.util;

import java.io.IOException;
import java.util.Properties;
import org.webswing.toolkit.util.Logger;

public class GitRepositoryState {
    private static GitRepositoryState instance;
    String tags;
    String branch;
    String dirty;
    String remoteOriginUrl;
    String commitId;
    String commitIdAbbrev;
    String describe;
    String describeShort;
    String commitUserName;
    String commitUserEmail;
    String commitMessageFull;
    String commitMessageShort;
    String commitTime;
    String closestTagName;
    String closestTagCommitCount;
    String buildUserName;
    String buildUserEmail;
    String buildTime;
    String buildHost;
    String buildVersion;

    public GitRepositoryState(Properties properties) {
        this.tags = String.valueOf(properties.get("git.tags"));
        this.branch = String.valueOf(properties.get("git.branch"));
        this.dirty = String.valueOf(properties.get("git.dirty"));
        this.remoteOriginUrl = String.valueOf(properties.get("git.remote.origin.url"));
        this.commitId = String.valueOf(properties.get("git.commit.id.full"));
        this.commitIdAbbrev = String.valueOf(properties.get("git.commit.id.abbrev"));
        this.describe = String.valueOf(properties.get("git.commit.id.describe"));
        this.describeShort = String.valueOf(properties.get("git.commit.id.describe-short"));
        this.commitUserName = String.valueOf(properties.get("git.commit.user.name"));
        this.commitUserEmail = String.valueOf(properties.get("git.commit.user.email"));
        this.commitMessageFull = String.valueOf(properties.get("git.commit.message.full"));
        this.commitMessageShort = String.valueOf(properties.get("git.commit.message.short"));
        this.commitTime = String.valueOf(properties.get("git.commit.time"));
        this.closestTagName = String.valueOf(properties.get("git.closest.tag.name"));
        this.closestTagCommitCount = String.valueOf(properties.get("git.closest.tag.commit.count"));
        this.buildUserName = String.valueOf(properties.get("git.build.user.name"));
        this.buildUserEmail = String.valueOf(properties.get("git.build.user.email"));
        this.buildTime = String.valueOf(properties.get("git.build.time"));
        this.buildHost = String.valueOf(properties.get("git.build.host"));
        this.buildVersion = String.valueOf(properties.get("git.build.version"));
    }

    public static GitRepositoryState getInstance() {
        if (instance == null) {
            Properties properties = new Properties();
            try {
                ClassLoader cl = GitRepositoryState.class.getClassLoader();
                if (cl == null) {
                    cl = ClassLoader.getSystemClassLoader();
                }
                properties.load(cl.getResourceAsStream("git.properties"));
            }
            catch (IOException e) {
                Logger.warn("Failed to load git.properties", new Object[0]);
            }
            instance = new GitRepositoryState(properties);
        }
        return instance;
    }

    public String getTags() {
        return this.tags;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getDirty() {
        return this.dirty;
    }

    public String getRemoteOriginUrl() {
        return this.remoteOriginUrl;
    }

    public String getCommitId() {
        return this.commitId;
    }

    public String getCommitIdAbbrev() {
        return this.commitIdAbbrev;
    }

    public String getDescribe() {
        return this.describe;
    }

    public String getDescribeShort() {
        return this.describeShort;
    }

    public String getCommitUserName() {
        return this.commitUserName;
    }

    public String getCommitUserEmail() {
        return this.commitUserEmail;
    }

    public String getCommitMessageFull() {
        return this.commitMessageFull;
    }

    public String getCommitMessageShort() {
        return this.commitMessageShort;
    }

    public String getCommitTime() {
        return this.commitTime;
    }

    public String getClosestTagName() {
        return this.closestTagName;
    }

    public String getClosestTagCommitCount() {
        return this.closestTagCommitCount;
    }

    public String getBuildUserName() {
        return this.buildUserName;
    }

    public String getBuildUserEmail() {
        return this.buildUserEmail;
    }

    public String getBuildTime() {
        return this.buildTime;
    }

    public String getBuildHost() {
        return this.buildHost;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }
}

