/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.webswing.toolkit.util.Logger;

public class ClasspathUtil {
    public static URL[] populateClassPath(String classpath, String relativeBase) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        String[] cp = ClasspathUtil.scanForFiles(classpath.split(";"), ClasspathUtil.toPath(relativeBase));
        Logger.debug("Swing classpath: " + Arrays.asList(cp), new Object[0]);
        for (String f : cp) {
            if (f.length() <= 0) continue;
            File file = new File(f).getAbsoluteFile();
            if (file.exists()) {
                urls.add(file.toURI().toURL());
                continue;
            }
            Logger.error("SwingMain:main ERROR: Required classpath file '" + f + "' does not exist!", new Object[0]);
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static String toPath(String relativeBase) {
        if (relativeBase == null || relativeBase.length() == 0) {
            return "";
        }
        if (relativeBase.endsWith("/") || relativeBase.endsWith("\\")) {
            return relativeBase;
        }
        return relativeBase + "/";
    }

    private static String[] scanForFiles(String[] patternPaths, String relativeBase) {
        ArrayList<String> result = new ArrayList<String>();
        for (String pattern : patternPaths) {
            boolean absolute;
            String[] pathSegs = (pattern = pattern.replaceAll("\\\\", "/")).split("/");
            boolean bl = absolute = pathSegs[0].length() == 0 || pathSegs[0].contains(":");
            if (pattern.contains("?") || pattern.contains("*")) {
                String currentBase = absolute ? "/" : relativeBase;
                ClasspathUtil.scanForPatternFiles(pathSegs, currentBase, result);
                continue;
            }
            result.add(absolute ? pattern : relativeBase + pattern);
        }
        return result.toArray(new String[result.size()]);
    }

    private static void scanForPatternFiles(String[] pathSegs, String currentBase, List<String> result) {
        block5: {
            String pathSeg;
            block3: {
                block4: {
                    pathSeg = pathSegs[0];
                    if (pathSegs.length <= 1) break block3;
                    if (!pathSeg.contains("?") && !pathSeg.contains("*")) break block4;
                    File currentBaseFolder = new File(currentBase.isEmpty() ? "." : currentBase).getAbsoluteFile();
                    if (!currentBaseFolder.exists() || !currentBaseFolder.isDirectory()) break block5;
                    for (String name : currentBaseFolder.list()) {
                        if (!ClasspathUtil.matches(pathSeg, name)) continue;
                        ClasspathUtil.scanForPatternFiles(Arrays.copyOfRange(pathSegs, 1, pathSegs.length), currentBase + name + "/", result);
                    }
                    break block5;
                }
                currentBase = currentBase + pathSeg + "/";
                ClasspathUtil.scanForPatternFiles(Arrays.copyOfRange(pathSegs, 1, pathSegs.length), currentBase, result);
                break block5;
            }
            File currentBaseFolder = new File(currentBase.isEmpty() ? "." : currentBase).getAbsoluteFile();
            if (currentBaseFolder.exists() && currentBaseFolder.isDirectory()) {
                for (String name : currentBaseFolder.list()) {
                    if (!ClasspathUtil.matches(pathSeg, name)) continue;
                    result.add(currentBase + name);
                }
            }
        }
    }

    private static boolean matches(String pathSeg, String name) {
        return name.matches("^" + pathSeg.replaceAll("\\.", "\\\\.").replaceAll("\\[", "\\\\[").replaceAll("\\]", "\\\\]").replaceAll("\\?", ".").replaceAll("\\*", ".*") + "$");
    }
}

