/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit.extra;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.webswing.common.WindowActionType;
import org.webswing.toolkit.util.Util;

public class WindowEventHandler {
    private Map<Window, Rectangle> previousSize = new HashMap<Window, Rectangle>();
    private boolean lockedOnEvent;
    private WindowActionType lockEventType;
    private Point referenceMouseLocation;
    private Window window;
    private static final Dimension DEFAULT_MINIMUM_WINDOW_SIZE = new Dimension(100, 25);

    public void handle(WindowActionType wat, MouseEvent e) {
        if (!this.lockedOnEvent) {
            if (501 == e.getID() && e.getButton() == 1) {
                this.lockedOnEvent = true;
                this.lockEventType = wat;
                this.referenceMouseLocation = e.getPoint();
                this.window = (Window)(e.getSource() instanceof Window ? e.getSource() : SwingUtilities.windowForComponent((Component)e.getSource()));
            }
        } else {
            switch (this.lockEventType) {
                case minimize: {
                    if (502 != e.getID() || e.getButton() != 1) break;
                    Window w = (Window)e.getSource();
                    Rectangle o = w.getBounds();
                    this.resizeWindow(w, 0, 0);
                    if (o.getSize().equals(w.getSize()) && this.previousSize.containsKey(w)) {
                        o = this.previousSize.get(w);
                        this.moveWindow(w, o.x, o.y);
                        this.resizeWindow(w, o.width, o.height);
                    } else {
                        Rectangle r = w.getBounds();
                        this.moveWindow(w, o.x + o.width / 2 - r.width / 2, o.y + o.height / 2 - r.height / 2);
                    }
                    if (w instanceof JFrame) {
                        ((JFrame)w).setExtendedState(0);
                    }
                    this.previousSize.put(w, o);
                    this.lockedOnEvent = false;
                    break;
                }
                case maximize: {
                    if (502 != e.getID() || e.getButton() != 1) break;
                    if (wat.equals((Object)WindowActionType.maximize)) {
                        Window w = (Window)e.getSource();
                        Rectangle o = w.getBounds();
                        if (w instanceof JFrame) {
                            JFrame frame = (JFrame)w;
                            if (frame.getExtendedState() == 6) {
                                frame.setExtendedState(0);
                                o = this.previousSize.get(w);
                                if (o != null) {
                                    this.moveWindow(w, o.x, o.y);
                                    this.resizeWindow(w, o.width, o.height);
                                }
                            } else {
                                frame.setExtendedState(6);
                            }
                        } else {
                            Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
                            if (o.x == 0 && o.y == 0 && o.width == size.width && o.height == size.height && this.previousSize.containsKey(w)) {
                                o = this.previousSize.get(w);
                                this.moveWindow(w, o.x, o.y);
                                this.resizeWindow(w, o.width, o.height);
                            } else {
                                this.moveWindow(w, 0, 0);
                                this.resizeWindow(w, size.width, size.height);
                            }
                        }
                        this.previousSize.put(w, o);
                    }
                    this.lockedOnEvent = false;
                    break;
                }
                case close: {
                    if (502 != e.getID() || e.getButton() != 1) break;
                    if (wat.equals((Object)WindowActionType.close)) {
                        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent((Window)e.getSource(), 201));
                    }
                    this.lockedOnEvent = false;
                    break;
                }
                case dock: {
                    if (502 != e.getID() || e.getButton() != 1) break;
                    if (wat.equals((Object)WindowActionType.dock)) {
                        Util.toggleWindowDock(this.window, false);
                    }
                    this.lockedOnEvent = false;
                    break;
                }
                case undock: {
                    if (502 != e.getID() || e.getButton() != 1) break;
                    if (wat.equals((Object)WindowActionType.undock)) {
                        Util.toggleWindowDock(this.window, true);
                    }
                    this.lockedOnEvent = false;
                    break;
                }
                case move: {
                    this.handleMouseReleaseEvent(e);
                    Window w = (Window)e.getSource();
                    if (w == null || Util.isWindowUndocked(w)) break;
                    if (506 == e.getID()) {
                        this.moveWindow(w, e.getXOnScreen() - this.referenceMouseLocation.x, e.getYOnScreen() - this.referenceMouseLocation.y);
                    }
                    if (!(e.getSource() instanceof JFrame)) break;
                    ((JFrame)e.getSource()).setExtendedState(0);
                    break;
                }
                case resizeUniTopLeft: {
                    this.handleMouseReleaseEvent(e);
                    if (506 == e.getID()) {
                        Window w = (Window)e.getSource();
                        Rectangle wb = w.getBounds();
                        Dimension wMinSize = this.getMinimumWindowSize(w);
                        Point stopPoint = new Point(wb.x + wb.width - wMinSize.width, wb.y + wb.height - wMinSize.height);
                        int x = (int)Math.min((double)e.getXOnScreen(), stopPoint.getX());
                        int y = (int)Math.min((double)e.getYOnScreen(), stopPoint.getY());
                        int width = wb.x + wb.width - x;
                        int height = wb.y + wb.height - y;
                        this.resizeAndMoveWindow(w, x, y, width, height);
                    }
                    if (!(e.getSource() instanceof JFrame)) break;
                    ((JFrame)e.getSource()).setExtendedState(0);
                    break;
                }
                case resizeUniTopRight: {
                    this.handleMouseReleaseEvent(e);
                    if (506 == e.getID()) {
                        Window w = (Window)e.getSource();
                        Rectangle wb = w.getBounds();
                        Dimension wMinSize = this.getMinimumWindowSize(w);
                        Point stopPoint = new Point(wb.x + wMinSize.width, wb.y + wb.height - wMinSize.height);
                        int x = wb.x;
                        int y = (int)Math.min((double)e.getYOnScreen(), stopPoint.getY());
                        int width = e.getXOnScreen() - wb.x;
                        int height = wb.y + wb.height - y;
                        this.resizeAndMoveWindow(w, x, y, width, height);
                    }
                    if (!(e.getSource() instanceof JFrame)) break;
                    ((JFrame)e.getSource()).setExtendedState(0);
                    break;
                }
                case resizeUniBottomLeft: {
                    this.handleMouseReleaseEvent(e);
                    if (506 == e.getID()) {
                        Window w = (Window)e.getSource();
                        Rectangle wb = w.getBounds();
                        Dimension wMinSize = this.getMinimumWindowSize(w);
                        Point stopPoint = new Point(wb.x + wb.width - wMinSize.width, wb.y + wMinSize.height);
                        int x = (int)Math.min((double)e.getXOnScreen(), stopPoint.getX());
                        int y = wb.y;
                        int width = wb.x + wb.width - x;
                        int height = e.getYOnScreen() - wb.y;
                        this.resizeAndMoveWindow(w, x, y, width, height);
                    }
                    if (!(e.getSource() instanceof JFrame)) break;
                    ((JFrame)e.getSource()).setExtendedState(0);
                    break;
                }
                case resizeUniBottomRight: {
                    this.handleMouseReleaseEvent(e);
                    if (506 == e.getID()) {
                        Window w = (Window)e.getSource();
                        this.resizeWindow(w, e.getXOnScreen() - w.getX(), e.getYOnScreen() - w.getY());
                    }
                    if (!(e.getSource() instanceof JFrame)) break;
                    ((JFrame)e.getSource()).setExtendedState(0);
                    break;
                }
                case resizeRight: {
                    this.handleMouseReleaseEvent(e);
                    if (506 == e.getID()) {
                        Window w = (Window)e.getSource();
                        this.resizeWindow(w, e.getXOnScreen() - w.getX(), w.getSize().height);
                    }
                    if (!(e.getSource() instanceof JFrame)) break;
                    ((JFrame)e.getSource()).setExtendedState(0);
                    break;
                }
                case resizeLeft: {
                    this.handleMouseReleaseEvent(e);
                    if (506 == e.getID()) {
                        Window w = (Window)e.getSource();
                        Rectangle wb = w.getBounds();
                        Dimension wMinSize = this.getMinimumWindowSize(w);
                        int x = Math.min(e.getXOnScreen(), wb.x + wb.width - wMinSize.width);
                        int width = wb.x + wb.width - x;
                        this.resizeAndMoveWindow(w, x, wb.y, width, wb.height);
                    }
                    if (!(e.getSource() instanceof JFrame)) break;
                    ((JFrame)e.getSource()).setExtendedState(0);
                    break;
                }
                case resizeBottom: {
                    this.handleMouseReleaseEvent(e);
                    if (506 == e.getID()) {
                        Window w = (Window)e.getSource();
                        this.resizeWindow(w, w.getSize().width, e.getYOnScreen() - w.getY());
                    }
                    if (!(e.getSource() instanceof JFrame)) break;
                    ((JFrame)e.getSource()).setExtendedState(0);
                    break;
                }
                case resizeTop: {
                    this.handleMouseReleaseEvent(e);
                    if (506 == e.getID()) {
                        Window w = (Window)e.getSource();
                        Rectangle wb = w.getBounds();
                        Dimension wMinSize = this.getMinimumWindowSize(w);
                        int y = Math.min(e.getYOnScreen(), wb.y + wb.height - wMinSize.height);
                        int height = wb.y + wb.height - y;
                        this.resizeAndMoveWindow(w, wb.x, y, wb.width, height);
                    }
                    if (!(e.getSource() instanceof JFrame)) break;
                    ((JFrame)e.getSource()).setExtendedState(0);
                    break;
                }
                default: {
                    this.lockedOnEvent = false;
                }
            }
        }
    }

    private void handleMouseReleaseEvent(MouseEvent e) {
        if (502 == e.getID() && e.getButton() == 1) {
            Window w = (Window)e.getSource();
            this.previousSize.remove(w);
            this.lockedOnEvent = false;
        }
    }

    private Dimension getMinimumWindowSize(Window w) {
        return w.getMinimumSize();
    }

    public void moveWindow(Window w, int x, int y) {
        w.setLocation(x, y);
    }

    public void resizeWindow(Window w, int width, int height) {
        this.resizeAndOrMoveWindow(w, null, width, height);
    }

    public void resizeAndMoveWindow(Window w, int x, int y, int width, int height) {
        this.resizeAndOrMoveWindow(w, new Point(x, y), width, height);
    }

    private void resizeAndOrMoveWindow(Window w, Point location, int width, int height) {
        if (w instanceof JFrame) {
            ((JFrame)w).setExtendedState(0);
        }
        Dimension originalSize = w.getSize();
        Dimension newSize = new Dimension(width, height);
        this.validateSize(w, newSize);
        if (!originalSize.equals(newSize)) {
            SwingUtilities.invokeLater(() -> {
                w.setSize(newSize);
                if (location != null) {
                    w.setLocation(location.x, location.y);
                }
            });
        }
    }

    private void validateSize(Window w, Dimension newSize) {
        newSize.width = Math.max(WindowEventHandler.DEFAULT_MINIMUM_WINDOW_SIZE.width, newSize.width);
        newSize.height = Math.max(WindowEventHandler.DEFAULT_MINIMUM_WINDOW_SIZE.height, newSize.height);
    }

    public boolean isEventHandlingLocked() {
        if (!(!this.lockedOnEvent || this.window != null && this.window.isEnabled() && this.window.isShowing())) {
            this.lockedOnEvent = false;
        }
        return this.lockedOnEvent;
    }

    public Window getLockedToWindow() {
        if (this.isEventHandlingLocked()) {
            return this.window;
        }
        return null;
    }
}

