/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.webswing.toolkit.api.WebswingMessagingApi;
import org.webswing.toolkit.api.messaging.WebswingMessage;
import org.webswing.toolkit.api.messaging.WebswingMessageListener;
import org.webswing.toolkit.api.messaging.WebswingTopic;
import org.webswing.toolkit.util.DeamonThreadFactory;
import org.webswing.toolkit.util.Logger;
import org.webswing.toolkit.util.Services;
import org.webswing.toolkit.util.Util;

public class WebswingMessagingApiImpl
implements WebswingMessagingApi {
    private ExecutorService messageProcessor = Executors.newSingleThreadExecutor(DeamonThreadFactory.getInstance("Webswing Messaging API processor"));
    private Map<WebswingMessageListener, Class> listeners = new ConcurrentHashMap<WebswingMessageListener, Class>();

    public <T> WebswingTopic<T> getSharedTopic(final Class<T> messageType) {
        return new WebswingTopic<T>(){

            public void publish(T message) throws IOException {
                if (message == null || !(message instanceof Serializable)) {
                    throw new IllegalArgumentException("Publishing failed. Message is not Serializable.");
                }
                Services.getConnectionService().messageApiPublish((Serializable)message);
            }

            public void subscribe(WebswingMessageListener<T> listener) {
                WebswingMessagingApiImpl.this.listeners.put(listener, messageType);
            }

            public void unsubscribe(WebswingMessageListener<T> listener) {
                WebswingMessagingApiImpl.this.listeners.remove(listener);
            }
        };
    }

    public boolean hasListenerForClass(String msgtype) {
        ClassLoader cl = Util.getWebToolkit().getSwingClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        try {
            Class<?> msgclass = cl.loadClass(msgtype);
            for (Class registeredclass : this.listeners.values()) {
                if (!registeredclass.isAssignableFrom(msgclass)) continue;
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            Logger.warn("WebswingMessagingApiImpl: Failed to process Message. Message class " + msgtype + " not found.", new Object[0]);
        }
        return false;
    }

    public void processMessage(final Serializable object) {
        Iterator<WebswingMessageListener> iterator = this.listeners.keySet().iterator();
        while (iterator.hasNext()) {
            WebswingMessageListener l;
            final WebswingMessageListener listener = l = iterator.next();
            Class regclass = this.listeners.get(l);
            if (!regclass.isInstance(object)) continue;
            this.messageProcessor.submit(new Runnable(){

                @Override
                public void run() {
                    listener.onMessage(new WebswingMessage(){

                        public Object getMessage() {
                            return object;
                        }
                    });
                }
            });
        }
    }
}

