/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit;

import java.applet.Applet;
import java.awt.AWTException;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.JobAttributes;
import java.awt.KeyboardFocusManager;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.PageAttributes;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.SystemTray;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.event.WindowEvent;
import java.awt.font.TextAttribute;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodDescriptor;
import java.awt.image.ColorModel;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.ComponentPeer;
import java.awt.peer.DesktopPeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.KeyboardFocusManagerPeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.MouseInfoPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.RobotPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.SystemTrayPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.TrayIconPeer;
import java.awt.peer.WindowPeer;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.webswing.dispatch.CwmPaintDispatcher;
import org.webswing.dispatch.EventDispatcher;
import org.webswing.dispatch.PaintDispatcher;
import org.webswing.dispatch.WebEventDispatcher;
import org.webswing.dispatch.WebPaintDispatcher;
import org.webswing.model.Msg;
import org.webswing.toolkit.FocusEventCause;
import org.webswing.toolkit.WebClipboard;
import org.webswing.toolkit.WebCursor;
import org.webswing.toolkit.WebDesktopPeer;
import org.webswing.toolkit.WebDialogPeer;
import org.webswing.toolkit.WebDragSourceContextPeer;
import org.webswing.toolkit.WebFileDialogPeer;
import org.webswing.toolkit.WebFontPeer;
import org.webswing.toolkit.WebFramePeer;
import org.webswing.toolkit.WebInputMethodDescriptor;
import org.webswing.toolkit.WebKeyboardFocusManagerPeer;
import org.webswing.toolkit.WebMouseDragGestureRecognizer;
import org.webswing.toolkit.WebMouseInfoPeer;
import org.webswing.toolkit.WebPanelPeer;
import org.webswing.toolkit.WebRobotPeer;
import org.webswing.toolkit.WebSystemTrayPeer;
import org.webswing.toolkit.WebWindowPeer;
import org.webswing.toolkit.WebswingApiImpl;
import org.webswing.toolkit.WebswingMessagingApiImpl;
import org.webswing.toolkit.api.WebswingApi;
import org.webswing.toolkit.api.WebswingApiProvider;
import org.webswing.toolkit.api.WebswingMessagingApi;
import org.webswing.toolkit.api.lifecycle.ShutdownReason;
import org.webswing.toolkit.extra.WindowManager;
import org.webswing.toolkit.util.DeamonThreadFactory;
import org.webswing.toolkit.util.Logger;
import org.webswing.toolkit.util.Util;
import sun.awt.SunToolkit;
import sun.awt.image.SurfaceManager;
import sun.awt.windows.ThemeReader;
import sun.java2d.SurfaceData;
import sun.print.PrintJob2D;

public abstract class WebToolkit
extends SunToolkit
implements WebswingApiProvider {
    public static final Font defaultFont = new Font("Dialog", 0, 12);
    public static final String BACKGROUND_WINDOW_ID = "BG";
    private static Object TREELOCK = null;
    private EventDispatcher eventDispatcher;
    private PaintDispatcher paintDispatcher;
    private WebswingApiImpl api = new WebswingApiImpl();
    private WebswingMessagingApiImpl msgapi = new WebswingMessagingApiImpl();
    private WindowManager windowManager = WindowManager.getInstance();
    private ClassLoader swingClassLoader;
    private static WebMouseInfoPeer mPeer;
    private static GraphicsConfiguration config;
    private Hashtable<String, FontPeer> cacheFontPeer;
    private WebClipboard clipboard;
    private Clipboard selectionClipboard;
    private boolean exiting = false;
    public static int screenWidth;
    public static int screenHeight;

    public void init() {
        String path;
        File desktopFolder;
        try {
            if (!System.getProperty("os.name", "").startsWith("Windows") && !System.getProperty("os.name", "").startsWith("Mac")) {
                Class<?> c = ClassLoader.getSystemClassLoader().loadClass("sun.awt.X11GraphicsEnvironment");
                Method initDisplayMethod = c.getDeclaredMethod("initDisplay", Boolean.TYPE);
                initDisplayMethod.setAccessible(true);
                initDisplayMethod.invoke(null, false);
            }
        }
        catch (Exception e) {
            Logger.error("Failed to init X11 display: ", e.getMessage());
        }
        if (System.getProperty("os.name", "").startsWith("Windows") && !(desktopFolder = new File(path = System.getenv("USERPROFILE") + "\\Desktop")).exists() && !desktopFolder.mkdir()) {
            Logger.error("Failed to create Desktop folder: " + path, new Object[0]);
        }
        this.installFonts();
    }

    private void installFonts() {
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Properties fontsProp = new Properties();
            String fontConfig = System.getProperty("sun.awt.fontconfig");
            if (fontConfig != null) {
                fontsProp.load(new FileInputStream(new File(fontConfig)));
                for (String name : fontsProp.stringPropertyNames()) {
                    if (!name.startsWith("filename.")) continue;
                    String file = fontsProp.getProperty(name);
                    Font font = Font.createFont(0, new File(file));
                    ge.registerFont(font);
                }
            }
        }
        catch (Exception e) {
            Logger.error("Failed to install fonts", e);
        }
    }

    public void startDispatchers() {
        this.eventDispatcher = Util.instantiateClass(EventDispatcher.class, "webswing.eventDispatcherClass", WebEventDispatcher.class.getName());
        if (this.eventDispatcher == null) {
            Logger.fatal("EventDispatcher not initialized. Exiting.", new Object[0]);
            System.exit(1);
        }
        Class defaultPaintDispatcher = Util.isCompositingWM() ? CwmPaintDispatcher.class : WebPaintDispatcher.class;
        this.paintDispatcher = Util.instantiateClass(PaintDispatcher.class, "webswing.paintDispatcherClass", defaultPaintDispatcher.getName());
        if (this.paintDispatcher == null) {
            Logger.fatal("PaintDispatcher not initialized. Exiting.", new Object[0]);
            System.exit(1);
        }
        Logger.info("Webswing Event Dispatcher: " + this.eventDispatcher.getClass().getName(), new Object[0]);
        Logger.info("Webswing Paint Dispatcher: " + this.paintDispatcher.getClass().getName(), new Object[0]);
    }

    public void initSize(Integer width, Integer height) {
        Integer desktopWidth = Math.max(300, width);
        Integer desktopHeight = Math.max(300, height);
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.initSize(desktopWidth, desktopHeight));
        } else {
            int oldWidht = screenWidth;
            int oldHeight = screenHeight;
            screenWidth = desktopWidth;
            screenHeight = desktopHeight;
            this.displayChanged();
            WebToolkit.resetGC();
            Util.resetWindowsGC(screenWidth, screenHeight);
            this.getPaintDispatcher().notifyScreenSizeChanged(oldWidht, oldHeight, screenWidth, screenHeight);
        }
    }

    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public PaintDispatcher getPaintDispatcher() {
        return this.paintDispatcher;
    }

    public WebToolkit() {
        if (System.getProperty("java.version").startsWith("1.6") || System.getProperty("java.version").startsWith("1.7")) {
            try {
                Method m = SunToolkit.class.getDeclaredMethod("setDataTransfererClassName", String.class);
                m.setAccessible(true);
                m.invoke(null, "org.webswing.toolkit.WebDataTransfer");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final Object targetToPeer(Object paramObject) {
        return SunToolkit.targetToPeer(paramObject);
    }

    public static final void targetDisposedPeer(Object paramObject1, Object paramObject2) {
        SunToolkit.targetDisposedPeer(paramObject1, paramObject2);
    }

    @Override
    protected void initializeDesktopProperties() {
        if (Boolean.getBoolean("webswing.isolatedFs")) {
            this.desktopProperties.put("Shell.shellFolderManager", "org.webswing.toolkit.extra.IsolatedFsShellFolderManager");
        } else if (System.getProperty("os.name", "").startsWith("Windows")) {
            this.desktopProperties.put("Shell.shellFolderManager", "sun.awt.shell.Win32ShellFolderManager2");
        }
        this.desktopProperties.put("DnD.gestureMotionThreshold", 2);
        this.desktopProperties.put("DnD.Autoscroll.initialDelay", 100);
        this.desktopProperties.put("DnD.Autoscroll.interval", 100);
        this.desktopProperties.put("DnD.Autoscroll.cursorHysteresis", 10);
        this.desktopProperties.put("awt.dynamicLayoutSupported", true);
        this.desktopProperties.put("awt.file.showAttribCol", false);
        this.desktopProperties.put("awt.file.showHiddenFiles", false);
        this.desktopProperties.put("awt.mouse.numButtons", 5);
        this.desktopProperties.put("awt.multiClickInterval", 500);
        this.desktopProperties.put("awt.wheelMousePresent", true);
        this.desktopProperties.put("win.3d.backgroundColor", new Color(240, 240, 240));
        this.desktopProperties.put("win.3d.darkShadowColor", new Color(105, 105, 105));
        this.desktopProperties.put("win.3d.highlightColor", new Color(255, 255, 255));
        this.desktopProperties.put("win.3d.lightColor", new Color(227, 227, 227));
        this.desktopProperties.put("win.3d.shadowColor", new Color(160, 160, 160));
        this.desktopProperties.put("win.ansiFixed.font", Font.decode("Monospaced 0 13"));
        this.desktopProperties.put("win.ansiFixed.font.height", 13);
        this.desktopProperties.put("win.ansiVar.font", Font.decode("Dialog 0 11"));
        this.desktopProperties.put("win.ansiVar.font.height", 11);
        this.desktopProperties.put("win.button.textColor", new Color(0, 0, 0));
        this.desktopProperties.put("win.caret.width", 1);
        this.desktopProperties.put("win.defaultGUI.font", Font.decode("Dialog 0 11"));
        this.desktopProperties.put("win.defaultGUI.font.height", 11);
        this.desktopProperties.put("win.desktop.backgroundColor", new Color(0, 0, 0));
        this.desktopProperties.put("win.deviceDefault.font", Font.decode("Dialog 1 13"));
        this.desktopProperties.put("win.deviceDefault.font.height", 13);
        this.desktopProperties.put("win.drag.height", 4);
        this.desktopProperties.put("win.drag.width", 4);
        this.desktopProperties.put("win.frame.activeBorderColor", new Color(180, 180, 180));
        this.desktopProperties.put("win.frame.activeCaptionColor", new Color(153, 180, 209));
        this.desktopProperties.put("win.frame.activeCaptionGradientColor", new Color(185, 209, 234));
        this.desktopProperties.put("win.frame.backgroundColor", new Color(255, 255, 255));
        this.desktopProperties.put("win.frame.captionButtonHeight", 22);
        this.desktopProperties.put("win.frame.captionButtonWidth", 36);
        this.desktopProperties.put("win.frame.captionFont", Font.decode("Dialog 0 12"));
        this.desktopProperties.put("win.frame.captionFont.height", 12);
        this.desktopProperties.put("win.frame.captionGradientsOn", true);
        this.desktopProperties.put("win.frame.captionHeight", 22);
        this.desktopProperties.put("win.frame.captionTextColor", new Color(0, 0, 0));
        this.desktopProperties.put("win.frame.color", new Color(100, 100, 100));
        this.desktopProperties.put("win.frame.fullWindowDragsOn", true);
        this.desktopProperties.put("win.frame.inactiveBorderColor", new Color(244, 247, 252));
        this.desktopProperties.put("win.frame.inactiveCaptionColor", new Color(191, 205, 219));
        this.desktopProperties.put("win.frame.inactiveCaptionGradientColor", new Color(215, 228, 242));
        this.desktopProperties.put("win.frame.inactiveCaptionTextColor", new Color(0, 0, 0));
        this.desktopProperties.put("win.frame.sizingBorderWidth", 5);
        this.desktopProperties.put("win.frame.smallCaptionButtonHeight", 22);
        this.desktopProperties.put("win.frame.smallCaptionButtonWidth", 22);
        this.desktopProperties.put("win.frame.smallCaptionFont", Font.decode("Dialog 0 12"));
        this.desktopProperties.put("win.frame.smallCaptionFont.height", 12);
        this.desktopProperties.put("win.frame.smallCaptionHeight", 22);
        this.desktopProperties.put("win.frame.textColor", new Color(0, 0, 0));
        this.desktopProperties.put("win.highContrast.on", false);
        this.desktopProperties.put("win.icon.font", Font.decode("Dialog 0 12"));
        this.desktopProperties.put("win.icon.font.height", 12);
        this.desktopProperties.put("win.icon.hspacing", 75);
        this.desktopProperties.put("win.icon.titleWrappingOn", true);
        this.desktopProperties.put("win.icon.vspacing", 75);
        this.desktopProperties.put("win.item.highlightColor", new Color(51, 153, 255));
        this.desktopProperties.put("win.item.highlightTextColor", new Color(255, 255, 255));
        this.desktopProperties.put("win.item.hotTrackedColor", new Color(0, 102, 204));
        this.desktopProperties.put("win.item.hotTrackingOn", true);
        this.desktopProperties.put("win.mdi.backgroundColor", new Color(171, 171, 171));
        this.desktopProperties.put("win.menu.backgroundColor", new Color(240, 240, 240));
        this.desktopProperties.put("win.menu.buttonWidth", 19);
        this.desktopProperties.put("win.menu.font", Font.decode("Dialog 0 12"));
        this.desktopProperties.put("win.menu.font.height", 12);
        this.desktopProperties.put("win.menu.height", 19);
        this.desktopProperties.put("win.menu.keyboardCuesOn", false);
        this.desktopProperties.put("win.menu.textColor", new Color(0, 0, 0));
        this.desktopProperties.put("win.menubar.backgroundColor", new Color(240, 240, 240));
        this.desktopProperties.put("win.messagebox.font", Font.decode("Dialog 0 12"));
        this.desktopProperties.put("win.messagebox.font.height", 12);
        this.desktopProperties.put("win.oemFixed.font", Font.decode("Dialog 0 12"));
        this.desktopProperties.put("win.oemFixed.font.height", 12);
        this.desktopProperties.put("win.properties.version", 3);
        this.desktopProperties.put("win.scrollbar.backgroundColor", new Color(200, 200, 200));
        this.desktopProperties.put("win.scrollbar.height", 17);
        this.desktopProperties.put("win.scrollbar.width", 17);
        this.desktopProperties.put("win.status.font", Font.decode("Dialog 0 12"));
        this.desktopProperties.put("win.status.font.height", 12);
        this.desktopProperties.put("win.system.font", Font.decode("Dialog 1 13"));
        this.desktopProperties.put("win.system.font.height", 13);
        this.desktopProperties.put("win.systemFixed.font", Font.decode("Dialog 0 12"));
        this.desktopProperties.put("win.systemFixed.font.height", 12);
        this.desktopProperties.put("win.text.fontSmoothingContrast", 1200);
        this.desktopProperties.put("win.text.fontSmoothingOn", true);
        this.desktopProperties.put("win.text.fontSmoothingOrientation", 1);
        this.desktopProperties.put("win.text.fontSmoothingType", 2);
        this.desktopProperties.put("win.text.grayedTextColor", new Color(109, 109, 109));
        this.desktopProperties.put("win.tooltip.backgroundColor", new Color(255, 255, 225));
        this.desktopProperties.put("win.tooltip.font", Font.decode("Dialog 0 12"));
        this.desktopProperties.put("win.tooltip.font.height", 12);
        this.desktopProperties.put("win.tooltip.textColor", new Color(0, 0, 0));
        this.desktopProperties.put("win.xpstyle.colorName", "NormalColor");
        this.desktopProperties.put("win.xpstyle.dllName", "C:\\WINDOWS\\resources\\themes\\Aero\\Aero.msstyles");
        this.desktopProperties.put("win.xpstyle.sizeName", "NormalSize");
        this.desktopProperties.put("win.xpstyle.themeActive", true);
        if (System.getProperty("os.name", "").startsWith("Windows")) {
            try {
                Field xpStyleEnabledField = ThemeReader.class.getDeclaredField("xpStyleEnabled");
                xpStyleEnabledField.setAccessible(true);
                xpStyleEnabledField.setBoolean(null, true);
            }
            catch (Exception e) {
                Logger.debug("Failed to set xpStyleEnabled to true", e);
            }
        }
        if (Util.isDD()) {
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            this.desktopProperties.put("awt.font.desktophints", hints);
        }
        System.setProperty("swing.disablevistaanimation", "true");
        int repaintInterval = 400;
        UIManager.put("ProgressBar.repaintInterval", repaintInterval);
        UIManager.put("ProgressBar.cycleTime", repaintInterval * 60);
    }

    @Override
    public boolean needUpdateWindow() {
        return true;
    }

    @Override
    public boolean isTranslucencyCapable(GraphicsConfiguration paramGraphicsConfiguration) {
        return true;
    }

    @Override
    public boolean isFrameStateSupported(int state) throws HeadlessException {
        return true;
    }

    public KeyboardFocusManagerPeer createKeyboardFocusManagerPeer(KeyboardFocusManager paramKeyboardFocusManager) throws HeadlessException {
        return new WebKeyboardFocusManagerPeer();
    }

    @Override
    public FramePeer createFrame(Frame frame) throws HeadlessException {
        WebFramePeer localWFramePeer = this.createWebFramePeer(frame);
        return localWFramePeer;
    }

    public static void registerPeer(Component target, ComponentPeer peer) {
        WebToolkit.targetCreatedPeer(target, peer);
    }

    abstract WebFramePeer createWebFramePeer(Frame var1) throws HeadlessException;

    @Override
    public DialogPeer createDialog(Dialog paramDialog) throws HeadlessException {
        WebDialogPeer localdialogPeer = this.createWebDialogPeer(paramDialog);
        return localdialogPeer;
    }

    abstract WebDialogPeer createWebDialogPeer(Dialog var1);

    @Override
    public boolean isModalityTypeSupported(Dialog.ModalityType mt) {
        return true;
    }

    @Override
    public WindowPeer createWindow(Window paramWindow) throws HeadlessException {
        WebWindowPeer localwindowPeer = this.createWebWindowPeer(paramWindow);
        return localwindowPeer;
    }

    abstract WebWindowPeer createWebWindowPeer(Window var1);

    @Override
    public PanelPeer createPanel(Panel panel) {
        if (panel instanceof Applet) {
            return super.createPanel(panel);
        }
        WebPanelPeer localpanelPeer = this.createWebPanelPeer(panel);
        return localpanelPeer;
    }

    abstract WebPanelPeer createWebPanelPeer(Panel var1);

    @Override
    public FileDialogPeer createFileDialog(FileDialog paramFileDialog) throws HeadlessException {
        WebFileDialogPeer localFileDialogPeer = this.createWebFileDialogPeer(paramFileDialog);
        return localFileDialogPeer;
    }

    abstract WebFileDialogPeer createWebFileDialogPeer(FileDialog var1);

    @Override
    public synchronized MouseInfoPeer getMouseInfoPeer() {
        if (mPeer == null) {
            mPeer = new WebMouseInfoPeer();
        }
        return mPeer;
    }

    @Override
    public FontPeer getFontPeer(String paramString, int paramInt) {
        FontPeer localObject = null;
        String str = paramString.toLowerCase();
        if (null != this.cacheFontPeer && null != (localObject = this.cacheFontPeer.get(str + paramInt))) {
            return localObject;
        }
        localObject = new WebFontPeer(paramString, paramInt);
        if (localObject != null) {
            if (null == this.cacheFontPeer) {
                this.cacheFontPeer = new Hashtable(5, 0.9f);
            }
            if (null != this.cacheFontPeer) {
                this.cacheFontPeer.put(str + paramInt, localObject);
            }
        }
        return localObject;
    }

    @Override
    public Clipboard getSystemClipboard() throws HeadlessException {
        return this.getWebswingClipboard();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebClipboard getWebswingClipboard() {
        WebToolkit webToolkit = this;
        synchronized (webToolkit) {
            if (this.clipboard == null) {
                this.clipboard = new WebClipboard("default", true);
            }
        }
        return this.clipboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clipboard getSystemSelection() throws HeadlessException {
        WebToolkit webToolkit = this;
        synchronized (webToolkit) {
            if (this.selectionClipboard == null) {
                this.selectionClipboard = new WebClipboard("selection", false);
            }
        }
        return this.selectionClipboard;
    }

    @Override
    protected Object lazilyLoadDesktopProperty(String name) {
        if ("awt.font.desktophints".equals(name)) {
            return SunToolkit.getDesktopFontHints();
        }
        return super.lazilyLoadDesktopProperty(name);
    }

    @Override
    protected RenderingHints getDesktopAAHints() {
        RenderingHints hints = new RenderingHints(null);
        hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_TEXT_LCD_CONTRAST, (Object)140);
        return hints;
    }

    @Override
    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent paramDragGestureEvent) throws InvalidDnDOperationException {
        return WebDragSourceContextPeer.createDragSourceContextPeer(paramDragGestureEvent);
    }

    @Override
    public <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> type, DragSource dragSource, Component component, int act, DragGestureListener listener) {
        if (MouseDragGestureRecognizer.class.equals(type)) {
            return (T)new WebMouseDragGestureRecognizer(dragSource, component, act, listener);
        }
        return null;
    }

    protected int getScreenWidth() {
        return screenWidth;
    }

    protected int getScreenHeight() {
        return screenHeight;
    }

    @Override
    public int getScreenResolution() throws HeadlessException {
        return 72;
    }

    @Override
    public ColorModel getColorModel() throws HeadlessException {
        if (config == null) {
            WebToolkit.resetGC();
        }
        return config.getColorModel();
    }

    @Override
    public void sync() {
    }

    @Override
    public Map<TextAttribute, ?> mapInputMethodHighlight(InputMethodHighlight paramInputMethodHighlight) throws HeadlessException {
        return null;
    }

    public static void resetGC() {
        config = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public abstract void displayChanged();

    @Override
    public InputMethodDescriptor getInputMethodAdapterDescriptor() throws AWTException {
        return new WebInputMethodDescriptor();
    }

    protected boolean syncNativeQueue() {
        return true;
    }

    @Override
    public void grab(Window paramWindow) {
    }

    @Override
    public void ungrab(Window paramWindow) {
    }

    @Override
    public ButtonPeer createButton(Button paramButton) throws HeadlessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextFieldPeer createTextField(TextField paramTextField) throws HeadlessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ChoicePeer createChoice(Choice paramChoice) throws HeadlessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public LabelPeer createLabel(Label paramLabel) throws HeadlessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListPeer createList(List paramList) throws HeadlessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CheckboxPeer createCheckbox(Checkbox paramCheckbox) throws HeadlessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScrollbarPeer createScrollbar(Scrollbar paramScrollbar) throws HeadlessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScrollPanePeer createScrollPane(ScrollPane paramScrollPane) throws HeadlessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextAreaPeer createTextArea(TextArea paramTextArea) throws HeadlessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public MenuBarPeer createMenuBar(MenuBar paramMenuBar) throws HeadlessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public MenuPeer createMenu(Menu paramMenu) throws HeadlessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PopupMenuPeer createPopupMenu(PopupMenu paramPopupMenu) throws HeadlessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public MenuItemPeer createMenuItem(MenuItem paramMenuItem) throws HeadlessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem paramCheckboxMenuItem) throws HeadlessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TrayIconPeer createTrayIcon(TrayIcon paramTrayIcon) throws HeadlessException, AWTException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SystemTrayPeer createSystemTray(SystemTray paramSystemTray) {
        return new WebSystemTrayPeer();
    }

    @Override
    public boolean isTraySupported() {
        return false;
    }

    public RobotPeer createRobot(Robot robot, GraphicsDevice device) throws AWTException {
        return new WebRobotPeer(robot, device);
    }

    @Override
    public boolean isDesktopSupported() {
        return true;
    }

    public boolean isWindowOpacityControlSupported() {
        return true;
    }

    @Override
    public boolean isWindowShapingSupported() {
        return false;
    }

    @Override
    public boolean isWindowTranslucencySupported() {
        return true;
    }

    @Override
    public DesktopPeer createDesktopPeer(Desktop paramDesktop) throws HeadlessException {
        return new WebDesktopPeer(paramDesktop);
    }

    @Override
    public PrintJob getPrintJob(Frame frame, String jobtitle, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        PrintJob2D localPrintJob2D = new PrintJob2D(frame, jobtitle, jobAttributes, pageAttributes);
        if (!localPrintJob2D.printDialog()) {
            localPrintJob2D = null;
        }
        return localPrintJob2D;
    }

    @Override
    public PrintJob getPrintJob(Frame frame, String jobtitle, Properties paramProperties) {
        return this.getPrintJob(frame, jobtitle, null, null);
    }

    @Override
    public void beep() {
    }

    @Override
    public Dimension getBestCursorSize(int preferredWidth, int preferredHeight) throws HeadlessException {
        return new Dimension(preferredWidth, preferredHeight);
    }

    @Override
    public int getMaximumCursorColors() throws HeadlessException {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean getLockingKeyState(int keyCode) throws UnsupportedOperationException {
        return false;
    }

    public GraphicsConfiguration getGraphicsConfig() {
        if (config == null) {
            WebToolkit.resetGC();
        }
        return config;
    }

    @Override
    public boolean areExtraMouseButtonsEnabled() throws HeadlessException {
        return true;
    }

    @Override
    protected void loadSystemColors(int[] systemColors) throws HeadlessException {
        if (systemColors != null && systemColors.length == 26) {
            systemColors[0] = -16777216;
            systemColors[1] = -6703919;
            systemColors[2] = -16777216;
            systemColors[3] = -4934476;
            systemColors[4] = -4207141;
            systemColors[5] = -12366252;
            systemColors[6] = -722948;
            systemColors[7] = -1;
            systemColors[8] = -10197916;
            systemColors[9] = -16777216;
            systemColors[10] = -986896;
            systemColors[11] = -16777216;
            systemColors[12] = -1;
            systemColors[13] = -16777216;
            systemColors[14] = -13395457;
            systemColors[15] = -1;
            systemColors[16] = -9605779;
            systemColors[17] = -986896;
            systemColors[18] = -16777216;
            systemColors[19] = -1842205;
            systemColors[20] = -1;
            systemColors[21] = -6250336;
            systemColors[22] = -9868951;
            systemColors[23] = -3618616;
            systemColors[24] = -31;
            systemColors[25] = -16777216;
        }
    }

    @Override
    public boolean isModalExclusionTypeSupported(Dialog.ModalExclusionType exclusionType) {
        return true;
    }

    public abstract boolean webConpoenentPeerUpdateGraphicsData();

    public abstract SurfaceData webComponentPeerReplaceSurfaceData(SurfaceManager var1);

    public abstract int shouldNativelyFocusHeavyweight(Component var1, Component var2, boolean var3, boolean var4, long var5, FocusEventCause var7);

    public abstract boolean deliverFocus(Component var1, Component var2, boolean var3, boolean var4, long var5, FocusEventCause var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int executeOnBeforeShutdownListeners(final ShutdownReason reason) {
        ExecutorService executor = Executors.newSingleThreadExecutor(DeamonThreadFactory.getInstance("Webswing pre-shutdown thread"));
        try {
            long wait = Long.getLong("webswing.syncCallTimeout", 3000L);
            Integer delay = executor.submit(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return WebToolkit.this.api.fireBeforeShutdownListeners(reason);
                }
            }).get(wait, TimeUnit.MILLISECONDS);
            int n = delay;
            return n;
        }
        catch (Exception e) {
            Logger.error("Failed to execute before-shutdown listeners", e);
        }
        finally {
            executor.shutdownNow();
        }
        return 0;
    }

    public synchronized void exitSwing(int i) {
        if (!this.exiting) {
            this.exiting = true;
            Thread shutdownThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        WebToolkit.this.getPaintDispatcher().notifyApplicationExiting();
                        WebToolkit.this.api.fireShutdownListeners();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                }
            });
            shutdownThread.setName("Webswing shutdown thread");
            shutdownThread.setDaemon(true);
            shutdownThread.start();
        }
    }

    public void defaultShutdownProcedure() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Window w : Window.getWindows()) {
                    w.dispatchEvent(new WindowEvent(w, 201));
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Window w : Window.getWindows()) {
                    w.setVisible(false);
                    w.dispose();
                }
            }
        });
    }

    public Object getTreeLock() {
        if (TREELOCK == null) {
            TREELOCK = new JPanel().getTreeLock();
        }
        return TREELOCK;
    }

    public WebswingApi getApi() {
        return this.api;
    }

    public WebswingMessagingApi getMessagingApi() {
        return this.msgapi;
    }

    public void processApiEvent(Msg event) {
        this.api.processEvent(event);
    }

    public boolean messageApiHasListenerForClass(String msgtype) {
        return this.msgapi.hasListenerForClass(msgtype);
    }

    public void messageApiProcessMessage(Serializable object) {
        this.msgapi.processMessage(object);
    }

    @Override
    public Cursor createCustomCursor(Image cursor, Point hotSpot, String name) throws IndexOutOfBoundsException, HeadlessException {
        return new WebCursor(cursor, hotSpot, name);
    }

    public void setSwingClassLoader(ClassLoader swingClassLoader) {
        this.swingClassLoader = swingClassLoader;
    }

    public ClassLoader getSwingClassLoader() {
        return this.swingClassLoader;
    }

    static {
        screenWidth = Math.max(300, Integer.parseInt(System.getProperty("webswing.screenWidth", "300")));
        screenHeight = Math.max(300, Integer.parseInt(System.getProperty("webswing.screenHeight", "300")));
    }
}

