/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit;

import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.peer.RobotPeer;
import java.util.HashSet;
import java.util.UUID;
import org.webswing.model.c2s.KeyboardEventMsgIn;
import org.webswing.model.c2s.MouseEventMsgIn;
import org.webswing.model.c2s.PixelsAreaResponseMsgIn;
import org.webswing.model.s2c.AppFrameMsgOut;
import org.webswing.model.s2c.PixelsAreaRequestMsgOut;
import org.webswing.toolkit.util.Logger;
import org.webswing.toolkit.util.Services;
import org.webswing.toolkit.util.Util;

public class WebRobotPeer
implements RobotPeer {
    GraphicsDevice device;
    private Point mousePos = new Point(0, 0);
    private int button;
    private int buttons;
    HashSet<Integer> pressedKeys = new HashSet();

    public WebRobotPeer(Robot robot, GraphicsDevice device) {
        this.device = device;
    }

    @Override
    public void mouseMove(int x, int y) {
        this.mousePos = this.getValidPoint(x, y);
        this.sendMouseEvent(MouseEventMsgIn.MouseEventType.mousemove, 0, this.mousePos);
    }

    @Override
    public void mousePress(int swingmask) {
        this.buttons = this.toButtonsWebEventMask(swingmask);
        this.button = this.getButtonPressed(swingmask);
        this.sendMouseEvent(MouseEventMsgIn.MouseEventType.mousedown, 0, this.mousePos);
    }

    @Override
    public void mouseRelease(int swingmask) {
        this.buttons = this.toButtonsWebEventMask(swingmask);
        this.button = this.getButtonPressed(swingmask);
        this.sendMouseEvent(MouseEventMsgIn.MouseEventType.mouseup, 0, this.mousePos);
    }

    @Override
    public void mouseWheel(int wheelAmt) {
        this.sendMouseEvent(MouseEventMsgIn.MouseEventType.mousewheel, wheelAmt, this.mousePos);
    }

    @Override
    public void keyPress(int keycode) {
        this.pressedKeys.add(keycode);
        this.sendKeyEvent(KeyboardEventMsgIn.KeyEventType.keydown, keycode);
        this.sendKeyEvent(KeyboardEventMsgIn.KeyEventType.keypress, keycode);
    }

    @Override
    public void keyRelease(int keycode) {
        this.pressedKeys.remove(keycode);
        this.sendKeyEvent(KeyboardEventMsgIn.KeyEventType.keyup, keycode);
    }

    @Override
    public int getRGBPixel(int x, int y) {
        return this.getRGBPixels(new Rectangle(x, y, 1, 1))[0];
    }

    @Override
    public int[] getRGBPixels(Rectangle bounds) {
        BufferedImage resultImage = new BufferedImage(bounds.width, bounds.height, 2);
        AppFrameMsgOut msg = new AppFrameMsgOut();
        PixelsAreaRequestMsgOut pixelsRequest = new PixelsAreaRequestMsgOut();
        pixelsRequest.setCorrelationId(UUID.randomUUID().toString());
        pixelsRequest.setX(bounds.x);
        pixelsRequest.setY(bounds.y);
        pixelsRequest.setW(bounds.width);
        pixelsRequest.setH(bounds.height);
        msg.setPixelsRequest(pixelsRequest);
        try {
            PixelsAreaResponseMsgIn result = (PixelsAreaResponseMsgIn)Services.getConnectionService().sendObjectSync(msg, pixelsRequest.getCorrelationId());
            Image image = Services.getImageService().readFromDataUrl(result.getPixels());
            Graphics g = resultImage.getGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
        }
        catch (Exception e) {
            Logger.error("Failed to get pixels area from browser.", e);
        }
        return ((DataBufferInt)resultImage.getRaster().getDataBuffer()).getData();
    }

    public void dispose() {
    }

    private void sendKeyEvent(KeyboardEventMsgIn.KeyEventType type, int keycode) {
        KeyboardEventMsgIn kme = new KeyboardEventMsgIn();
        kme.setType(type);
        kme.setShift(this.isShift());
        kme.setMeta(this.isMeta());
        kme.setAlt(this.isAlt());
        kme.setCtrl(this.isCtrl());
        kme.setKeycode(keycode);
        int character = !this.isShift() && keycode >= 65 && keycode <= 90 ? keycode + 32 : keycode;
        kme.setCharacter(character);
        Util.getWebToolkit().getEventDispatcher().dispatchEvent(kme);
    }

    private void sendMouseEvent(MouseEventMsgIn.MouseEventType type, int wheelDelta, Point mousePos) {
        MouseEventMsgIn mme = new MouseEventMsgIn();
        mme.setShift(this.isShift());
        mme.setAlt(this.isAlt());
        mme.setCtrl(this.isCtrl());
        mme.setMeta(this.isMeta());
        mme.setButton(this.button);
        mme.setButtons(this.buttons);
        mme.setType(type);
        mme.setWheelDelta(wheelDelta);
        mme.setX(mousePos.x);
        mme.setY(mousePos.y);
        Util.getWebToolkit().getEventDispatcher().dispatchEvent(mme);
    }

    private boolean isMeta() {
        return this.pressedKeys.contains(524);
    }

    private boolean isCtrl() {
        return this.pressedKeys.contains(17);
    }

    private boolean isAlt() {
        return this.pressedKeys.contains(18) || this.pressedKeys.contains(65406);
    }

    private boolean isShift() {
        return this.pressedKeys.contains(16);
    }

    private Point getValidPoint(int x, int y) {
        Rectangle bounds = this.device.getDefaultConfiguration().getBounds();
        x = Math.max(x, bounds.x);
        x = Math.min(x, bounds.x + bounds.width);
        y = Math.max(y, bounds.y);
        y = Math.min(y, bounds.y + bounds.height);
        return new Point(x, y);
    }

    private int toButtonsWebEventMask(int swingMask) {
        int result = 0;
        if ((swingMask & 0x10) == 16) {
            result |= 2;
        }
        if ((swingMask & 8) == 8) {
            result |= 4;
        }
        if ((swingMask & 4) == 4) {
            result |= 8;
        }
        return result;
    }

    private int getButtonPressed(int swingMask) {
        if ((swingMask & 0x10) == 16) {
            return 1;
        }
        if ((swingMask & 8) == 8) {
            return 2;
        }
        if ((swingMask & 4) == 4) {
            return 3;
        }
        return 0;
    }
}

