/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit;

import java.awt.AWTError;
import java.awt.HeadlessException;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JOptionPane;
import org.webswing.toolkit.WebPrintService;
import org.webswing.toolkit.WebPrinterJob;
import org.webswing.toolkit.util.WebPrintDialog;

public class WebPrinterJobWrapper
extends PrinterJob {
    public static final int DPI = 72;
    private PrinterJob delegate;
    private PrintRequestAttributeSet attribs = new HashPrintRequestAttributeSet();

    public WebPrinterJobWrapper() {
        String nm = System.getProperty("webswing.printerJobDelegate", null);
        try {
            this.delegate = (PrinterJob)Class.forName(nm).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new AWTError("PrinterJob not found: " + nm);
        }
        catch (InstantiationException e) {
            throw new AWTError("Could not instantiate PrinterJob: " + nm);
        }
        catch (IllegalAccessException e) {
            throw new AWTError("Could not access PrinterJob: " + nm);
        }
        this.setPageFormat(this.defaultPage());
    }

    private void setPageFormat(PageFormat defaultPage) {
        PrintRequestAttributeSet a = this.toAttributes(defaultPage);
        this.attribs.addAll(a);
    }

    @Override
    public void setPrintable(Printable painter) {
        this.delegate.setPrintable(painter);
    }

    @Override
    public void setPrintable(Printable painter, PageFormat format) {
        this.delegate.setPrintable(painter, format);
        this.setPageFormat(format);
    }

    @Override
    public void setPageable(Pageable document) throws NullPointerException {
        this.delegate.setPageable(document);
    }

    @Override
    public void setPrintService(PrintService service) throws PrinterException {
        this.delegate.setPrintService(service);
    }

    @Override
    public boolean printDialog() throws HeadlessException {
        boolean confirmed;
        PrintService[] services = WebPrinterJobWrapper.wrappedLookupPrintServices(null, null);
        int defaultServiceIndex = this.getIndexOfPrintService(services);
        WebPrintDialog dialog = new WebPrintDialog(services, defaultServiceIndex, this.attribs, null);
        dialog.setVisible(true);
        boolean bl = confirmed = dialog.getStatus() == 1;
        if (confirmed) {
            try {
                this.delegate.setPrintService(dialog.getService());
            }
            catch (PrinterException e) {
                JOptionPane.showMessageDialog(null, "There is a problem with selected Print Service.\n" + e.getMessage(), "Error", 0);
            }
            PrintRequestAttributeSet a = dialog.getAttributes();
            this.attribs.addAll(a);
        }
        return confirmed;
    }

    private int getIndexOfPrintService(PrintService[] services) {
        PrintService defaultService = PrintServiceLookup.lookupDefaultPrintService();
        if (defaultService != null) {
            for (int i = 0; i < services.length; ++i) {
                PrintService s = services[i];
                if (!s.getName().equals(defaultService.getName())) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean printDialog(PrintRequestAttributeSet attributes) throws HeadlessException {
        if (attributes == null) {
            throw new NullPointerException("attributes");
        }
        this.attribs.addAll(attributes);
        boolean result = this.printDialog();
        attributes.addAll(this.attribs);
        return result;
    }

    @Override
    public PageFormat pageDialog(PageFormat page) throws HeadlessException {
        this.setPageFormat(page);
        this.printDialog();
        return WebPrinterJobWrapper.toPageFormat(this.attribs);
    }

    @Override
    public PageFormat pageDialog(PrintRequestAttributeSet attributes) throws HeadlessException {
        if (attributes == null) {
            throw new NullPointerException("attributes");
        }
        this.attribs.addAll(attributes);
        this.printDialog();
        return WebPrinterJobWrapper.toPageFormat(this.attribs);
    }

    @Override
    public PageFormat defaultPage(PageFormat page) {
        return this.delegate.defaultPage(page);
    }

    @Override
    public PageFormat validatePage(PageFormat page) {
        return this.delegate.validatePage(page);
    }

    @Override
    public void print() throws PrinterException {
        this.delegate.print(this.attribs);
    }

    @Override
    public void print(PrintRequestAttributeSet attributes) throws PrinterException {
        this.attribs.addAll(attributes);
        this.delegate.print(attributes);
    }

    @Override
    public void setCopies(int copies) {
        this.delegate.setCopies(copies);
    }

    @Override
    public int getCopies() {
        return this.delegate.getCopies();
    }

    @Override
    public String getUserName() {
        return this.delegate.getUserName();
    }

    @Override
    public void setJobName(String jobName) {
        this.delegate.setJobName(jobName);
    }

    @Override
    public String getJobName() {
        return this.delegate.getJobName();
    }

    @Override
    public void cancel() {
        this.delegate.cancel();
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public PrintService getPrintService() {
        return this.delegate.getPrintService();
    }

    private PrintRequestAttributeSet toAttributes(PageFormat format) {
        HashPrintRequestAttributeSet attrs = new HashPrintRequestAttributeSet();
        OrientationRequested orientation = format.getOrientation() == 0 ? OrientationRequested.LANDSCAPE : OrientationRequested.PORTRAIT;
        Paper p = format.getPaper();
        MediaSizeName size = WebPrinterJobWrapper.findMedia(p.getWidth(), p.getHeight());
        float x = (float)p.getImageableY() / 72.0f;
        float y = (float)p.getImageableX() / 72.0f;
        float w = (float)p.getImageableWidth() / 72.0f;
        float h = (float)p.getImageableHeight() / 72.0f;
        MediaPrintableArea margins = new MediaPrintableArea(x, y, w, h, 25400);
        attrs.add(size);
        attrs.add(orientation);
        attrs.add(margins);
        return attrs;
    }

    public static MediaSizeName findMedia(double width, double height) {
        MediaSizeName[] mediaArray = WebPrintService.mediaSizes;
        MediaSizeName result = WebPrintService.mediaSizes[0];
        float w = (float)(width / 72.0);
        float h = (float)(height / 72.0);
        if (w <= 0.0f || h <= 0.0f) {
            throw new IllegalArgumentException("args must be +ve values");
        }
        double d1 = w * w + h * h;
        float f1 = w;
        float f2 = h;
        for (int i = 0; i < mediaArray.length; ++i) {
            MediaSizeName mediaSizeName = mediaArray[i];
            MediaSize mSize = MediaSize.getMediaSizeForName(mediaSizeName);
            float[] size = mSize.getSize(25400);
            if (w == size[0] && h == size[1]) {
                result = mediaSizeName;
                break;
            }
            f1 = w - size[0];
            f2 = h - size[1];
            double d2 = f1 * f1 + f2 * f2;
            if (!(d2 < d1)) continue;
            d1 = d2;
            result = mediaSizeName;
        }
        return result;
    }

    public static PrintService[] wrappedLookupPrintServices(DocFlavor flavor, AttributeSet attributes) {
        String delegateClass = System.getProperty("webswing.printerJobDelegate", null);
        if (delegateClass.equals(WebPrinterJob.class.getCanonicalName())) {
            return new PrintService[]{WebPrintService.getService()};
        }
        PrintService[] services = PrintServiceLookup.lookupPrintServices(flavor, attributes);
        if (services == null) {
            services = new PrintService[]{};
        }
        return services;
    }

    public static PageFormat toPageFormat(PrintRequestAttributeSet a) {
        MediaSize msz;
        OrientationRequested orientation = (OrientationRequested)a.get(OrientationRequested.class);
        MediaSizeName name = (MediaSizeName)a.get(Media.class);
        MediaPrintableArea area = (MediaPrintableArea)a.get(MediaPrintableArea.class);
        PageFormat result = new PageFormat();
        if (orientation != null) {
            if (orientation == OrientationRequested.LANDSCAPE) {
                result.setOrientation(0);
            } else {
                result.setOrientation(1);
            }
        }
        Paper p = new Paper();
        if (name != null && (msz = MediaSize.getMediaSizeForName(name)) != null) {
            double paperWid = msz.getX(25400) * 72.0f;
            double paperHgt = msz.getY(25400) * 72.0f;
            p.setSize(paperWid, paperHgt);
            if (area == null) {
                p.setImageableArea(72.0, 72.0, paperWid - 72.0, paperHgt - 72.0);
            }
        }
        if (area != null) {
            float[] printableArea = area.getPrintableArea(25400);
            for (int i = 0; i < printableArea.length; ++i) {
                printableArea[i] = printableArea[i] * 72.0f;
            }
            p.setImageableArea(printableArea[0], printableArea[1], printableArea[2], printableArea[3]);
        }
        result.setPaper(p);
        return result;
    }
}

