/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit;

import java.awt.FileDialog;
import java.awt.Window;
import java.awt.peer.FileDialogPeer;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.webswing.toolkit.WebWindowPeer;

public abstract class WebFileDialogPeer
extends WebWindowPeer
implements FileDialogPeer {
    private FileDialog dialog;
    private JFileChooser fc = new JFileChooser(){
        private static final long serialVersionUID = 1L;

        @Override
        public void approveSelection() {
            super.approveSelection();
            WebFileDialogPeer.this.dialog.setFile(WebFileDialogPeer.this.fc.getSelectedFile().getName());
            WebFileDialogPeer.this.dialog.setDirectory(WebFileDialogPeer.this.fc.getCurrentDirectory().getPath() + File.separator);
            WebFileDialogPeer.this.dialog.hide();
        }

        @Override
        public void cancelSelection() {
            super.cancelSelection();
            WebFileDialogPeer.this.dialog.setFile(null);
            WebFileDialogPeer.this.dialog.hide();
        }
    };

    public WebFileDialogPeer(FileDialog paramFileDialog) {
        super(new JDialog());
        this.dialog = paramFileDialog;
        this.setFile(this.dialog.getFile());
        this.fc.setMultiSelectionEnabled(false);
    }

    @Override
    public void blockWindows(List<Window> windows) {
    }

    @Override
    public void setDirectory(String dir) {
    }

    @Override
    public void setFile(String file) {
        if (file != null) {
            this.fc.setSelectedFile(new File(file));
        }
    }

    @Override
    public void setFilenameFilter(final FilenameFilter filter) {
        FileFilter ffilter = new FileFilter(){

            @Override
            public String getDescription() {
                return "filter";
            }

            @Override
            public boolean accept(File f) {
                return filter.accept(f.getParentFile(), f.getName());
            }
        };
        this.fc.setFileFilter(ffilter);
    }

    @Override
    public void show() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (WebFileDialogPeer.this.dialog.getMode() == 0) {
                    WebFileDialogPeer.this.fc.showOpenDialog(WebFileDialogPeer.this.dialog.getOwner());
                } else {
                    WebFileDialogPeer.this.fc.showSaveDialog(WebFileDialogPeer.this.dialog.getOwner());
                }
            }
        }).start();
    }

    @Override
    public void hide() {
    }
}

