/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.PaintEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.util.LinkedList;
import java.util.UUID;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.webswing.common.GraphicsWrapper;
import org.webswing.common.WindowActionType;
import org.webswing.dispatch.WebPaintDispatcher;
import org.webswing.toolkit.WebToolkit;
import org.webswing.toolkit.WebWindowPeer;
import org.webswing.toolkit.extra.DndEventHandler;
import org.webswing.toolkit.extra.WindowManager;
import org.webswing.toolkit.ge.WebGraphicsConfig;
import org.webswing.toolkit.util.DummyGraphics2D;
import org.webswing.toolkit.util.Logger;
import org.webswing.toolkit.util.Services;
import org.webswing.toolkit.util.Util;
import sun.awt.AWTAccessor;
import sun.awt.PaintEventDispatcher;
import sun.awt.RepaintArea;
import sun.awt.image.OffScreenImage;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.SurfaceManager;
import sun.awt.image.ToolkitImage;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.pipe.Region;

public abstract class WebComponentPeer
implements ComponentPeer {
    private String guid = UUID.randomUUID().toString();
    protected long pData;
    protected boolean destroyed;
    protected Object target;
    private RepaintArea paintArea;
    private int oldWidth;
    private int oldHeight;
    private int oldX;
    private int oldY;
    private SurfaceData surfaceData;
    OffScreenImage image;
    private Image windowDecorationImage;
    private LinkedList<WebComponentPeer> hwLayers = new LinkedList();
    Image webImage;
    private Color background;
    private Color foreground;
    private Font font;
    protected float opacity;
    private String currentCursor = "default";

    public String getGuid() {
        return this.guid;
    }

    public BufferedImage extractBufferedImage(Rectangle sub) {
        BufferedImage safeImage = new BufferedImage(sub.width, sub.height, 2);
        if (this.isInitialized()) {
            Graphics2D g = (Graphics2D)safeImage.getGraphics();
            g.drawImage(this.image, 0, 0, sub.width, sub.height, sub.x, sub.y, sub.x + sub.width, sub.y + sub.height, null);
            for (WebComponentPeer wcp : this.hwLayers) {
                Insets i = ((Window)this.getTarget()).getInsets();
                Rectangle b = wcp.getBounds();
                Rectangle bt = new Rectangle(b.x + i.left, b.y + i.top, b.width, b.height);
                if (!bt.intersects(sub)) continue;
                Rectangle dst = sub.intersection(bt);
                Rectangle src = new Rectangle(dst);
                dst.translate(-sub.x, -sub.y);
                src.translate(-bt.x, -bt.y);
                g.drawImage(wcp.image, dst.x, dst.y, dst.width + dst.x, dst.height + dst.y, src.x, src.y, src.width + src.x, src.height + src.y, null);
            }
            g.drawImage(this.windowDecorationImage, 0, 0, sub.width, sub.height, sub.x, sub.y, sub.x + sub.width, sub.y + sub.height, null);
            g.dispose();
        }
        return safeImage;
    }

    public Image extractWebImage() {
        Graphics g = this.webImage.getGraphics();
        if (this.windowDecorationImage != null && Services.getDirectDrawService().isDirty(this.windowDecorationImage)) {
            g.drawImage(this.windowDecorationImage, 0, 0, null);
            Services.getDirectDrawService().resetImage(this.windowDecorationImage);
        }
        for (WebComponentPeer wcp : this.hwLayers) {
            Point p = SwingUtilities.convertPoint((Component)wcp.getTarget(), new Point(0, 0), (Component)this.getTarget());
            g.drawImage(wcp.webImage, p.x, p.y, null);
            Services.getDirectDrawService().resetImageBeforeRepaint(wcp.webImage);
        }
        g.dispose();
        return Services.getDirectDrawService().extractWebImage(this.webImage);
    }

    public void updateWindowDecorationImage() {
        int h;
        int w;
        if (this.target == null || !(this.target instanceof JDialog) && !(this.target instanceof JFrame) || !this.isInitialized()) {
            return;
        }
        if (this.isUndecorated()) {
            if (this.windowDecorationImage != null) {
                if (Util.isDD()) {
                    Services.getDirectDrawService().resetImage(this.windowDecorationImage);
                }
                this.windowDecorationImage = null;
            }
            return;
        }
        if (Util.isDD()) {
            w = this.webImage.getWidth(null);
            h = this.webImage.getHeight(null);
            this.windowDecorationImage = Services.getDirectDrawService().createImage(w, h);
        } else {
            w = this.image.getWidth();
            h = this.image.getHeight();
            this.windowDecorationImage = new BufferedImage(w, h, 2);
        }
        Graphics g = this.windowDecorationImage.getGraphics();
        Services.getImageService().getWindowDecorationTheme().paintWindowDecoration(g, this.target, w, h);
        g.dispose();
        Util.getWebToolkit().getPaintDispatcher().notifyWindowDecorationUpdated(this.getGuid(), this.getBounds(), ((WebWindowPeer)this).getInsets());
    }

    private boolean isInitialized() {
        if (Util.isDD()) {
            return this.webImage != null;
        }
        return this.image != null;
    }

    public Component getHwComponentAt(int x, int y) {
        Component result = (Component)this.getTarget();
        for (WebComponentPeer wcp : this.hwLayers) {
            Insets insets = ((Window)this.getTarget()).getInsets();
            if (!wcp.getBounds().contains(x - this.getBounds().x - insets.left, y - this.getBounds().y - insets.top)) continue;
            result = (Component)wcp.getTarget();
        }
        return result;
    }

    protected boolean isUndecorated() {
        WebWindowPeer webPeer;
        if (this.target == null) {
            return true;
        }
        if (this.target instanceof JWindow) {
            return true;
        }
        if (this.target instanceof JFrame && ((JFrame)this.target).isUndecorated() || this.target instanceof JDialog && ((JDialog)this.target).isUndecorated()) {
            return true;
        }
        if (this instanceof WebWindowPeer && (webPeer = (WebWindowPeer)this).getUndecoratedOverride() != null) {
            return webPeer.getUndecoratedOverride();
        }
        return false;
    }

    public WebComponentPeer(Component t) {
        Color foreground;
        Font localFont;
        Color localColor;
        this.target = t;
        this.paintArea = new RepaintArea();
        WebToolkit.registerPeer(t, this);
        if (((Component)this.target).isVisible()) {
            this.show();
        }
        if ((localColor = ((Component)this.target).getForeground()) != null) {
            this.setForeground(localColor);
        }
        if ((localFont = ((Component)this.target).getFont()) != null) {
            this.setFont(localFont);
        }
        if (!((Component)this.target).isEnabled()) {
            this.disable();
        }
        Rectangle localRectangle = ((Component)this.target).getBounds();
        this.setBounds(localRectangle.x, localRectangle.y, localRectangle.width, localRectangle.height, 3);
        Color background = ((Component)this.target).getBackground();
        if (background == null) {
            background = Color.WHITE;
            ((Component)this.target).setBackground(background);
            this.setBackground(background);
        }
        if ((foreground = ((Component)this.target).getForeground()) == null) {
            foreground = Color.BLACK;
            ((Component)this.target).setForeground(foreground);
            this.setForeground(foreground);
        }
    }

    @Override
    public boolean isObscured() {
        return false;
    }

    @Override
    public boolean canDetermineObscurity() {
        return false;
    }

    @Override
    public void setVisible(boolean paramBoolean) {
        if (paramBoolean) {
            this.show();
        } else {
            this.hide();
        }
    }

    @Override
    public void setEnabled(boolean paramBoolean) {
        if (paramBoolean) {
            this.enable();
        } else {
            this.disable();
        }
    }

    @Override
    public void paint(Graphics paramGraphics) {
        ((Component)this.target).paint(paramGraphics);
    }

    public void repaint(long paramLong, int paramInt1, int paramInt2, int paramInt3, int paramInt4) {
        ((Component)this.target).repaint(paramLong, paramInt1, paramInt2, paramInt3, paramInt4);
    }

    @Override
    public void print(Graphics paramGraphics) {
        ((Component)this.target).print(paramGraphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBounds(int x, int y, int w, int h, int op) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            ComponentEvent e;
            boolean moved;
            Point validPosition = this.validate(x, y, w, h);
            boolean resized = w != this.oldWidth || h != this.oldHeight;
            boolean bl = moved = validPosition.x != this.oldX || validPosition.y != this.oldY;
            if (resized) {
                e = new ComponentEvent((Component)this.target, 101);
                this.postEvent(e);
            }
            if (moved) {
                e = new ComponentEvent((Component)this.target, 100);
                this.postEvent(e);
            }
            if (w != this.oldWidth || h != this.oldHeight) {
                try {
                    this.replaceSurfaceData(validPosition.x, validPosition.y, w, h);
                }
                catch (InvalidPipeException e2) {
                    Logger.error("WebComponentPeer:setBounds", e2);
                }
                this.notifyWindowBoundsChanged(new Rectangle(0, 0, w, h));
            }
            if (validPosition.x != this.oldX || validPosition.y != this.oldY || w != this.oldWidth || h != this.oldHeight) {
                if (this.oldWidth != 0 && this.oldHeight != 0 && this.target instanceof Window) {
                    Util.getWebToolkit().getWindowManager().requestRepaintAfterMove((Window)this.target, new Rectangle(this.oldX, this.oldY, this.oldWidth, this.oldHeight));
                }
                this.oldX = validPosition.x;
                this.oldY = validPosition.y;
                this.oldWidth = w;
                this.oldHeight = h;
            }
        }
    }

    protected void notifyWindowBoundsChanged(Rectangle rectangle) {
        Util.getWebToolkit().getPaintDispatcher().notifyWindowBoundsChanged(this.getGuid(), rectangle);
    }

    protected Point validate(int x, int y, int w, int h) {
        return new Point(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceSurfaceData(int x, int y, int w, int h) {
        SurfaceData localSurfaceData = null;
        Object object = ((Component)this.target).getTreeLock();
        synchronized (object) {
            WebComponentPeer webComponentPeer = this;
            synchronized (webComponentPeer) {
                if (Util.isDD()) {
                    this.webImage = Services.getDirectDrawService().createImage(w, h);
                } else {
                    if (w > 0 && h > 0) {
                        WebGraphicsConfig localWebGraphicsConfig = (WebGraphicsConfig)this.getGraphicsConfiguration();
                        this.image = (OffScreenImage)localWebGraphicsConfig.createAcceleratedImage((Component)this.target, w, h);
                        localSurfaceData = this.surfaceData;
                        this.surfaceData = Util.getWebToolkit().webComponentPeerReplaceSurfaceData(SurfaceManager.getManager(this.image));
                    } else {
                        this.image = null;
                        this.surfaceData = null;
                    }
                    if (localSurfaceData != null) {
                        localSurfaceData.invalidate();
                    }
                }
                this.updateWindowDecorationImage();
                this.repaintPeerTarget();
            }
        }
        if (localSurfaceData != null) {
            localSurfaceData.flush();
            localSurfaceData = null;
        }
    }

    @Override
    public void handleEvent(AWTEvent paramAWTEvent) {
    }

    @Override
    public void coalescePaintEvent(PaintEvent paramPaintEvent) {
        Rectangle localRectangle = paramPaintEvent.getUpdateRect();
        this.paintArea.add(localRectangle, paramPaintEvent.getID());
    }

    private void repaintPeerTarget() {
        Component localComponent = (Component)this.target;
        Rectangle localRectangle = AWTAccessor.getComponentAccessor().getBounds(localComponent);
        if (!((Component)this.target).getIgnoreRepaint()) {
            ((Component)this.target).invalidate();
            ((Component)this.target).validate();
            PaintEvent localPaintEvent = PaintEventDispatcher.getPaintEventDispatcher().createPaintEvent((Component)this.target, 0, 0, localRectangle.width, localRectangle.height);
            if (localPaintEvent != null) {
                this.postEvent(localPaintEvent);
            }
        }
    }

    @Override
    public Point getLocationOnScreen() {
        if (this.getTarget() instanceof Applet || this.getTarget() instanceof Window) {
            return this.getBounds().getLocation();
        }
        Point p = new Point(0, 0);
        SwingUtilities.convertPointToScreen(p, (Component)this.getTarget());
        return p;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return ((Component)this.target).getSize();
    }

    @Override
    public ColorModel getColorModel() {
        GraphicsConfiguration localGraphicsConfiguration = this.getGraphicsConfiguration();
        if (localGraphicsConfiguration != null) {
            return localGraphicsConfiguration.getColorModel();
        }
        return null;
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    @Override
    public Graphics getGraphics() {
        Font font;
        Color foreground;
        Color background = this.background;
        if (background == null) {
            background = SystemColor.window;
        }
        if ((foreground = this.foreground) == null) {
            foreground = SystemColor.windowText;
        }
        if ((font = this.font) == null) {
            font = WebToolkit.defaultFont;
        }
        GraphicsWrapper result = null;
        if (Util.isDD()) {
            Image wi = this.webImage;
            if (wi != null) {
                result = new GraphicsWrapper((Graphics2D)wi.getGraphics(), this);
                ((Graphics2D)result).setBackground(background);
                ((Graphics)result).setColor(foreground);
                ((Graphics)result).setFont(font);
            }
        } else {
            SurfaceData surface = this.surfaceData;
            if (surface != null) {
                result = new GraphicsWrapper(new SunGraphics2D(surface, foreground, background, font), this);
            } else {
                return new DummyGraphics2D();
            }
        }
        return result;
    }

    @Override
    public FontMetrics getFontMetrics(Font paramFont) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.notifyWindowClosed();
            if (Util.isDD()) {
                this.webImage = null;
            } else {
                SurfaceData localSurfaceData = this.surfaceData;
                this.surfaceData = null;
                if (localSurfaceData != null) {
                    localSurfaceData.invalidate();
                }
            }
            WebToolkit.targetDisposedPeer(this.target, this);
        }
    }

    protected void notifyWindowClosed() {
        Util.getWebToolkit().getPaintDispatcher().notifyWindowClosed(this.getGuid());
    }

    @Override
    public void setForeground(Color paramColor) {
        this.foreground = paramColor;
    }

    @Override
    public void setBackground(Color paramColor) {
        this.background = paramColor;
    }

    @Override
    public void setFont(Font paramFont) {
        this.font = paramFont;
    }

    @Override
    public void updateCursorImmediately() {
        if (Util.getWebToolkit().getEventDispatcher().isDndInProgress()) {
            this.notifyCursorUpdate(null, DndEventHandler.getCurrentDropTargetCursorName());
        } else {
            Window windowOnLocation;
            Window window;
            Point location = Util.getWebToolkit().getEventDispatcher().getLastMousePosition();
            if (location != null && this.target instanceof Window && ((window = (Window)this.target) == (windowOnLocation = WindowManager.getInstance().getVisibleWindowOnPosition(location.x, location.y)) || Util.isCompositingWM())) {
                if (WindowManager.getInstance().isBlockedByModality(window, false)) {
                    this.notifyCursorUpdate(Cursor.getPredefinedCursor(0), null);
                } else if (Util.isWindowDecorationPosition(window, location)) {
                    WindowActionType wat = Services.getImageService().getWindowDecorationTheme().getAction(window, new Point(location.x - window.getX(), location.y - window.getY()));
                    this.notifyCursorUpdate(wat.getCursor(), null);
                } else {
                    Component component = SwingUtilities.getDeepestComponentAt(window, location.x - window.getX(), location.y - window.getY());
                    component = component == null ? window : component;
                    this.notifyCursorUpdate(component.getCursor(), null);
                }
            }
        }
    }

    private void notifyCursorUpdate(Cursor c, Cursor overridenCursor) {
        Util.getWebToolkit().getPaintDispatcher().notifyCursorUpdate(c, overridenCursor, this.getGuid());
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    public Image createImage(ImageProducer paramImageProducer) {
        return new ToolkitImage(paramImageProducer);
    }

    @Override
    public Image createImage(int paramInt1, int paramInt2) {
        WebGraphicsConfig localwebGraphicsConfig = (WebGraphicsConfig)this.getGraphicsConfiguration();
        return localwebGraphicsConfig.createAcceleratedImage((Component)this.target, paramInt1, paramInt2);
    }

    @Override
    public VolatileImage createVolatileImage(int paramInt1, int paramInt2) {
        return new SunVolatileImage((Component)this.target, paramInt1, paramInt2);
    }

    public boolean prepareImage(Image paramImage, int paramInt1, int paramInt2, ImageObserver paramImageObserver) {
        return this.getToolkit().prepareImage(paramImage, paramInt1, paramInt2, paramImageObserver);
    }

    public int checkImage(Image paramImage, int paramInt1, int paramInt2, ImageObserver paramImageObserver) {
        return this.getToolkit().checkImage(paramImage, paramInt1, paramInt2, paramImageObserver);
    }

    @Override
    public GraphicsConfiguration getGraphicsConfiguration() {
        return ((WebToolkit)this.getToolkit()).getGraphicsConfig();
    }

    @Override
    public boolean handlesWheelScrolling() {
        return false;
    }

    @Override
    public void createBuffers(int paramInt, BufferCapabilities paramBufferCapabilities) throws AWTException {
        throw new AWTException("The operation requested is not supported");
    }

    @Override
    public Image getBackBuffer() {
        return null;
    }

    @Override
    public void flip(int paramInt1, int paramInt2, int paramInt3, int paramInt4, BufferCapabilities.FlipContents paramFlipContents) {
    }

    @Override
    public void destroyBuffers() {
    }

    @Override
    public void reparent(ContainerPeer paramContainerPeer) {
    }

    @Override
    public boolean isReparentSupported() {
        return false;
    }

    @Override
    public void layout() {
    }

    public Rectangle getBounds() {
        return ((Component)this.target).getBounds();
    }

    @Override
    public void applyShape(Region paramRegion) {
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public void show() {
    }

    public void hide() {
    }

    public void enable() {
    }

    public void disable() {
    }

    public void reshape(int paramInt1, int paramInt2, int paramInt3, int paramInt4) {
    }

    void postEvent(AWTEvent paramAWTEvent) {
        WebToolkit.postEvent(WebToolkit.targetToAppContext(this.target), paramAWTEvent);
    }

    public Object getTarget() {
        return this.target;
    }

    @Override
    public void setZOrder(ComponentPeer above) {
    }

    @Override
    public boolean updateGraphicsData(GraphicsConfiguration gc) {
        return Util.getWebToolkit().webConpoenentPeerUpdateGraphicsData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeHwLayer(WebComponentPeer peer) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.hwLayers.remove(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addHwLayer(WebComponentPeer peer) {
        Object object = WebPaintDispatcher.webPaintLock;
        synchronized (object) {
            this.hwLayers.add(peer);
        }
    }

    public String getCurrentCursor() {
        return this.currentCursor;
    }

    public void setCurrentCursor(String currentCursor) {
        this.currentCursor = currentCursor;
    }
}

