/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.dispatch;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.webswing.audio.AudioClip;
import org.webswing.dispatch.PaintDispatcher;
import org.webswing.model.internal.ExitMsgInternal;
import org.webswing.model.internal.OpenFileResultMsgInternal;
import org.webswing.model.internal.PrinterJobResultMsgInternal;
import org.webswing.model.s2c.AccessibilityMsg;
import org.webswing.model.s2c.ActionEventMsgOut;
import org.webswing.model.s2c.AppFrameMsgOut;
import org.webswing.model.s2c.AudioEventMsgOut;
import org.webswing.model.s2c.CopyEventMsg;
import org.webswing.model.s2c.CursorChangeEventMsg;
import org.webswing.model.s2c.FileDialogEventMsg;
import org.webswing.model.s2c.FocusEventMsg;
import org.webswing.model.s2c.LinkActionMsg;
import org.webswing.model.s2c.PasteRequestMsg;
import org.webswing.model.s2c.WindowMsg;
import org.webswing.toolkit.WebCursor;
import org.webswing.toolkit.WebToolkit;
import org.webswing.toolkit.WebWindowPeer;
import org.webswing.toolkit.api.clipboard.PasteRequestContext;
import org.webswing.toolkit.api.clipboard.WebswingClipboardData;
import org.webswing.toolkit.extra.IsolatedFsShellFolderManager;
import org.webswing.toolkit.util.DeamonThreadFactory;
import org.webswing.toolkit.util.Logger;
import org.webswing.toolkit.util.Services;
import org.webswing.toolkit.util.ToolkitUtil;
import org.webswing.toolkit.util.Util;

public abstract class AbstractPaintDispatcher
implements PaintDispatcher {
    private volatile Map<String, Set<Rectangle>> areasToUpdate = new HashMap<String, Set<Rectangle>>();
    private volatile FocusEventMsg focusEvent;
    private volatile AccessibilityMsg accessible;
    private AtomicBoolean clientReadyToReceive = new AtomicBoolean(true);
    private final Long ackTimeout = Long.getLong("webswing.paintAckTimeout", 5000L);
    private long lastReadyStateTime;
    private JFileChooser fileChooserDialog;
    private JDialog clipboardDialog;
    private ScheduledExecutorService executorService;
    private Object accessibilityLock = new Object();
    private boolean accessibilityUpdateScheduled;
    private Component accessibilityComponent;
    private Integer accessibilityX;
    private Integer accessibilityY;
    private WeakHashMap<Window, WeakReference<JFileChooser>> registeredFileChooserWindows = new WeakHashMap();
    private FileChooserShowingListener fileChooserVisibilityListener = new FileChooserShowingListener();
    private WeakHashMap<String, WeakReference<AudioClip>> registeredAudioClips = new WeakHashMap();
    private SecondaryLoop clipboardDialogLoop;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clientReadyToReceive() {
        Object object = webPaintLock;
        synchronized (object) {
            this.clientReadyToReceive.set(true);
        }
    }

    @Override
    public void notifyNewDirtyRegionQueued() {
    }

    @Override
    public RepaintManager getDefaultRepaintManager() {
        return RepaintManager.currentManager(null);
    }

    @Override
    public void notifyScreenSizeChanged(int oldWidht, int oldHeight, int screenWidth, int screenHeight) {
        this.clientReadyToReceive();
        Util.resetWindowsPosition(oldWidht, oldHeight);
        this.notifyWindowRepaintAll();
    }

    @Override
    public void notifyWindowDecorationUpdated(String guid, Rectangle bounds, Insets insets) {
        if (insets != null && bounds != null) {
            this.addDirtyArea(guid, new Rectangle(0, 0, bounds.width, insets.top));
            this.addDirtyArea(guid, new Rectangle(0, 0, insets.left, bounds.height));
            this.addDirtyArea(guid, new Rectangle(bounds.width - insets.right, 0, insets.right, bounds.height));
            this.addDirtyArea(guid, new Rectangle(0, bounds.height - insets.bottom, bounds.width, insets.bottom));
        }
    }

    @Override
    public void notifyWindowClosed(String guid) {
        this.removeDirtyArea(guid);
        AppFrameMsgOut f = new AppFrameMsgOut();
        WindowMsg fdEvent = new WindowMsg();
        fdEvent.setId(guid);
        f.setClosedWindow(fdEvent);
        Logger.debug("WebPaintDispatcher:notifyWindowClosed", guid);
        this.sendObject(f);
    }

    @Override
    public void notifyWindowRepaintAll() {
        this.notifyBackgroundAreaVisible(new Rectangle(Util.getWebToolkit().getScreenSize()));
        if (Util.isDD()) {
            Services.getDirectDrawService().resetCache();
            Util.repaintAllWindow();
        } else {
            for (Window w : Util.getAllWindows()) {
                if (!w.isShowing()) continue;
                this.addDirtyArea(w);
            }
        }
    }

    @Override
    public void notifyActionEvent(String windowId, String actionName, String data, byte[] binaryData) {
        AppFrameMsgOut f = new AppFrameMsgOut();
        ActionEventMsgOut actionEvent = new ActionEventMsgOut();
        actionEvent.setWindowId(windowId);
        actionEvent.setActionName(actionName);
        actionEvent.setData(data);
        actionEvent.setBinaryData(binaryData);
        f.setActionEvent(actionEvent);
        Logger.debug("WebPaintDispatcher:notifyActionEvent", f);
        this.sendObject(f);
    }

    @Override
    public void notifyOpenLinkAction(URI uri) {
        AppFrameMsgOut f = new AppFrameMsgOut();
        LinkActionMsg linkAction = new LinkActionMsg(LinkActionMsg.LinkActionType.url, uri.toString());
        f.setLinkAction(linkAction);
        Logger.info("WebPaintDispatcher:notifyOpenLinkAction", uri);
        this.sendObject(f);
    }

    @Override
    public void notifyCopyEvent(WebswingClipboardData data) {
        AppFrameMsgOut f = new AppFrameMsgOut();
        CopyEventMsg copyEvent = new CopyEventMsg(data.getText(), data.getHtml(), data.getImg(), data.getFiles(), false);
        f.setCopyEvent(copyEvent);
        Logger.debug("WebPaintDispatcher:notifyCopyEvent", f);
        this.sendObject(f);
    }

    @Override
    public void notifyFileDialogActive(Window window) {
        this.setFileChooserDialog(Util.discoverFileChooser(window));
        this.notifyFileDialogActive();
    }

    @Override
    public void notifyFileDialogActive() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this::notifyFileDialogActive);
        } else if (this.getFileChooserDialog() != null) {
            AppFrameMsgOut f = new AppFrameMsgOut();
            FileDialogEventMsg fdEvent = new FileDialogEventMsg(this.getFileChooserDialog());
            f.setFileDialogEvent(fdEvent);
            FileDialogEventMsg.FileDialogEventType fileChooserEventType = Util.getFileChooserEventType(this.getFileChooserDialog());
            if (fileChooserEventType == FileDialogEventMsg.FileDialogEventType.AutoUpload && this.getFileChooserDialog().getFileSelectionMode() == 1) {
                SwingUtilities.invokeLater(() -> {
                    try {
                        this.getFileChooserDialog().setSelectedFile(new File(this.getFileChooserDialog().getCurrentDirectory().getCanonicalPath()));
                        this.getFileChooserDialog().approveSelection();
                    }
                    catch (IOException e) {
                        this.getFileChooserDialog().cancelSelection();
                    }
                });
                return;
            }
            fdEvent.setEventType(fileChooserEventType);
            if (FileDialogEventMsg.FileDialogEventType.AutoUpload == fileChooserEventType || FileDialogEventMsg.FileDialogEventType.AutoSave == fileChooserEventType) {
                fdEvent.setAllowDelete(false);
                fdEvent.setAllowDownload(false);
                fdEvent.setAllowUpload(false);
                if (FileDialogEventMsg.FileDialogEventType.AutoUpload == fileChooserEventType) {
                    this.getFileChooserDialog().setCurrentDirectory(Util.getTimestampedTransferFolder("autoupload"));
                }
                Window d = SwingUtilities.getWindowAncestor(this.getFileChooserDialog());
                d.setBounds(0, 0, 1, 1);
                SwingUtilities.invokeLater(() -> {
                    Window d1 = SwingUtilities.getWindowAncestor(this.getFileChooserDialog());
                    d1.setBounds(0, 0, 1, 1);
                });
            }
            fdEvent.setSelection(Util.getFileChooserSelection(this.getFileChooserDialog()));
            fdEvent.addFilter(this.getFileChooserDialog().getChoosableFileFilters());
            fdEvent.setMultiSelection(this.getFileChooserDialog().isMultiSelectionEnabled());
            Logger.info("WebPaintDispatcher:notifyFileTransferBarActive " + fileChooserEventType.name(), new Object[0]);
            this.sendObject(f);
        }
    }

    @Override
    public void notifyFileDialogHidden() {
        AppFrameMsgOut f = new AppFrameMsgOut();
        FileDialogEventMsg fdEvent = new FileDialogEventMsg();
        fdEvent.setEventType(FileDialogEventMsg.FileDialogEventType.Close);
        f.setFileDialogEvent(fdEvent);
        Logger.info("WebPaintDispatcher:notifyFileTransferBarHidden " + FileDialogEventMsg.FileDialogEventType.Close.name(), new Object[0]);
        this.validateSelection(this.getFileChooserDialog());
        if (Boolean.getBoolean("webswing.allowAutoDownload") && this.getFileChooserDialog() != null && this.getFileChooserDialog().getDialogType() == 1) {
            try {
                File saveFile;
                Field resultValueField = JFileChooser.class.getDeclaredField("returnValue");
                resultValueField.setAccessible(true);
                if (resultValueField.get(this.getFileChooserDialog()).equals(0) && (saveFile = this.getFileChooserDialog().getSelectedFile()) != null) {
                    OpenFileResultMsgInternal msg = new OpenFileResultMsgInternal();
                    msg.setClientId(System.getProperty("webswing.clientId"));
                    msg.setFile(saveFile);
                    msg.setWaitForFile(true);
                    if (saveFile.exists()) {
                        msg.setOverwriteDetails(saveFile.length() + "|" + saveFile.lastModified());
                    }
                    this.sendObject(msg);
                }
            }
            catch (Exception e) {
                Logger.warn("Save file dialog's file monitoring failed: " + e.getMessage(), new Object[0]);
            }
        }
        this.setFileChooserDialog(null);
        this.sendObject(f);
    }

    @Override
    public void notifyDownloadSelectedFile() {
        File file;
        if (this.getFileChooserDialog() != null && Boolean.getBoolean("webswing.allowDownload") && (file = this.getFileChooserDialog().getSelectedFile()) != null && file.exists() && !file.isDirectory() && file.canRead()) {
            OpenFileResultMsgInternal f = new OpenFileResultMsgInternal();
            f.setClientId(System.getProperty("webswing.clientId"));
            f.setFile(file);
            this.sendObject(f);
        }
    }

    @Override
    public void notifyDeleteSelectedFile() {
        if (this.getFileChooserDialog() != null && Boolean.getBoolean("webswing.allowDelete")) {
            File[] selected = this.getFileChooserDialog().getSelectedFiles();
            if ((selected == null || selected.length == 0) && this.getFileChooserDialog().getSelectedFile() != null) {
                selected = new File[]{this.getFileChooserDialog().getSelectedFile()};
            }
            if (selected != null) {
                for (File f : selected) {
                    boolean deleted;
                    if (!f.exists() || !f.canWrite() || (deleted = f.delete())) continue;
                    Logger.info("notifyDeleteSelectedFile: Failed to delete file:" + f.getAbsolutePath(), new Object[0]);
                }
            }
            this.getFileChooserDialog().rescanCurrentDirectory();
        }
    }

    @Override
    public void notifyFileRequested(File file, boolean preview) {
        OpenFileResultMsgInternal f = new OpenFileResultMsgInternal();
        f.setClientId(System.getProperty("webswing.clientId"));
        f.setFile(file.getAbsoluteFile());
        f.setPreview(preview);
        this.sendObject(f);
    }

    @Override
    public void notifyPrintPdfFile(String id, File f) {
        PrinterJobResultMsgInternal printResult = new PrinterJobResultMsgInternal();
        printResult.setClientId(System.getProperty("webswing.clientId"));
        printResult.setTempFile(true);
        printResult.setId(id);
        printResult.setPdfFile(f);
        this.sendObject(printResult);
    }

    @Override
    public void notifyApplicationExiting() {
        this.notifyApplicationExiting(Integer.getInteger("webswing.waitForExit", 30000));
    }

    @Override
    public void notifyApplicationExiting(int waitBeforeKill) {
        ExitMsgInternal f = new ExitMsgInternal();
        f.setWaitForExit(waitBeforeKill);
        this.sendObject(f);
        this.getExecutorService().shutdownNow();
    }

    @Override
    public void notifyUrlRedirect(String url) {
        AppFrameMsgOut result = new AppFrameMsgOut();
        result.setLinkAction(new LinkActionMsg(LinkActionMsg.LinkActionType.redirect, url));
        this.sendObject(result);
    }

    @Override
    public void requestBrowserClipboard(PasteRequestContext ctx) {
        AppFrameMsgOut result = new AppFrameMsgOut();
        PasteRequestMsg paste = new PasteRequestMsg();
        paste.setTitle(ctx.getTitle());
        paste.setMessage(ctx.getMessage());
        result.setPasteRequest(paste);
        this.sendObject(result);
        if (this.clipboardDialogLoop != null) {
            this.clipboardDialogLoop.exit();
        }
        this.clipboardDialogLoop = Toolkit.getDefaultToolkit().getSystemEventQueue().createSecondaryLoop();
        this.clipboardDialogLoop.enter();
    }

    @Override
    public boolean closePasteRequestDialog() {
        if (this.clipboardDialogLoop != null) {
            return this.clipboardDialogLoop.exit();
        }
        return false;
    }

    @Override
    public void notifyComponentTreeRequested() {
        if (!Util.isTestMode()) {
            return;
        }
        AppFrameMsgOut f = new AppFrameMsgOut();
        f.setComponentTree(ToolkitUtil.getComponentTree());
        Logger.debug("WebPaintDispatcher:sendComponentTree", new Object[0]);
        this.sendObject(f);
    }

    @Override
    public void notifyWindowSwitchList() {
        AppFrameMsgOut f = new AppFrameMsgOut();
        f.setWindowSwitchList(Util.getWindowSwitchList());
        Logger.debug("WebPaintDispatcher:notifyWindowSwitchList", new Object[0]);
        this.sendObject(f);
    }

    protected ScheduledExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, DeamonThreadFactory.getInstance("Webswing Paint Dispatcher"));
        }
        return this.executorService;
    }

    protected void sendObject(Serializable object) {
        Logger.debug("WebPaintDispatcher:sendJsonObject", object);
        Services.getConnectionService().sendObject(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isClientReadyToReceiveOrResetAfterTimedOut() {
        Object object = webPaintLock;
        synchronized (object) {
            if (!this.clientReadyToReceive.get()) {
                if (System.currentTimeMillis() - this.lastReadyStateTime > this.ackTimeout) {
                    Logger.debug("paintDispatcher.clientReadyToReceive re-enabled after timeout", new Object[0]);
                    if (Util.isDD()) {
                        Services.getDirectDrawService().resetCache();
                    }
                    this.clientReadyToReceive();
                    this.lastReadyStateTime = System.currentTimeMillis();
                    return true;
                }
                return false;
            }
            this.lastReadyStateTime = System.currentTimeMillis();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isClientReadyToReceive() {
        Object object = webPaintLock;
        synchronized (object) {
            return this.clientReadyToReceive.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setClientNotReady() {
        Object object = webPaintLock;
        synchronized (object) {
            this.clientReadyToReceive.set(false);
        }
    }

    protected Map<String, Set<Rectangle>> popProcessableDirtyAreas() {
        Map<String, Set<Rectangle>> currentAreasToUpdate = this.areasToUpdate;
        this.areasToUpdate = Util.postponeNonShowingAreas(currentAreasToUpdate);
        return currentAreasToUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDirtyArea(String guid, Rectangle repaintedArea, boolean reset) {
        Object object = webPaintLock;
        synchronized (object) {
            if (repaintedArea.width > 0 && repaintedArea.height > 0) {
                if (this.areasToUpdate.containsKey(guid)) {
                    Set<Rectangle> rset = this.areasToUpdate.get(guid);
                    if (reset) {
                        rset.clear();
                    }
                    rset.add(repaintedArea);
                } else {
                    HashSet<Rectangle> rset = new HashSet<Rectangle>();
                    rset.add(repaintedArea);
                    this.areasToUpdate.put(guid, rset);
                }
                Logger.trace("WebPaintDispatcher:addDirtyArea", guid, repaintedArea);
            }
        }
    }

    protected void addDirtyArea(String guid, Rectangle repaintedArea) {
        this.addDirtyArea(guid, repaintedArea, false);
    }

    protected void addDirtyArea(Window w) {
        Rectangle bounds = w.getBounds();
        WebWindowPeer peer = (WebWindowPeer)WebToolkit.targetToPeer(w);
        if (peer != null) {
            this.addDirtyArea(peer.getGuid(), new Rectangle(0, 0, bounds.width, bounds.height));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDirtyArea(String guid) {
        Object object = webPaintLock;
        synchronized (object) {
            this.areasToUpdate.remove(guid);
        }
    }

    protected void fillFocusEvent(AppFrameMsgOut json) {
        if (this.focusEvent != null) {
            json.setFocusEvent(this.focusEvent);
            this.focusEvent = null;
        }
    }

    @Override
    public void notifyFocusEvent(FocusEventMsg msg) {
        this.focusEvent = msg;
        this.notifyAccessibilityInfoUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyAccessibilityInfoUpdate(Component a, int x, int y) {
        if (!Util.isAccessibilityEnabled()) {
            return;
        }
        Object object = this.accessibilityLock;
        synchronized (object) {
            this.accessibilityComponent = a;
            this.accessibilityX = x;
            this.accessibilityY = y;
            if (this.accessibilityUpdateScheduled) {
                return;
            }
            this.accessibilityUpdateScheduled = true;
        }
        SwingUtilities.invokeLater(() -> this.processAccessibility());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyAccessibilityInfoUpdate() {
        if (!Util.isAccessibilityEnabled()) {
            return;
        }
        Object object = this.accessibilityLock;
        synchronized (object) {
            this.accessibilityComponent = null;
            this.accessibilityX = null;
            this.accessibilityY = null;
            if (this.accessibilityUpdateScheduled) {
                return;
            }
            this.accessibilityUpdateScheduled = true;
        }
        SwingUtilities.invokeLater(() -> this.processAccessibility());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAccessibility() {
        Object object = this.accessibilityLock;
        synchronized (object) {
            if (this.accessibilityComponent != null) {
                this.sendNotifyAccessibilityInfoUpdate(Services.getConnectionService().getAccessibilityInfo(this.accessibilityComponent, this.accessibilityX, this.accessibilityY));
            } else {
                this.sendNotifyAccessibilityInfoUpdate(Services.getConnectionService().getAccessibilityInfo());
            }
            this.accessibilityUpdateScheduled = false;
        }
    }

    @Override
    public void clearAccessibilityInfoState() {
        this.accessible = null;
    }

    @Override
    public void notifyAccessibilityInfoUpdate(AccessibilityMsg msg) {
        this.sendNotifyAccessibilityInfoUpdate(msg);
    }

    private void sendNotifyAccessibilityInfoUpdate(AccessibilityMsg newAccessible) {
        if (newAccessible == null || this.accessible != null && newAccessible.equals(this.accessible)) {
            return;
        }
        this.accessible = newAccessible;
        AppFrameMsgOut f = new AppFrameMsgOut();
        f.setAccessible(this.accessible);
        Logger.debug("WebPaintDispatcher:sendNotifyAccessibilityInfo", f);
        this.sendObject(f);
    }

    @Override
    public JFileChooser getFileChooserDialog() {
        return this.fileChooserDialog;
    }

    protected void setFileChooserDialog(JFileChooser fileChooserDialog) {
        this.fileChooserDialog = fileChooserDialog;
    }

    protected JDialog getClipboardDialog() {
        return this.clipboardDialog;
    }

    protected void setClipboardDialog(JDialog clipboardDialog) {
        this.clipboardDialog = clipboardDialog;
    }

    @Override
    public void notifyCursorUpdate(Cursor cursor, Cursor overridenCursorName, String winId) {
        String webcursorName = null;
        Cursor webcursor = null;
        if (overridenCursorName == null) {
            if (cursor == null) {
                webcursorName = "default";
            } else {
                switch (cursor.getType()) {
                    case 0: {
                        webcursorName = "default";
                        break;
                    }
                    case 12: {
                        webcursorName = "pointer";
                        break;
                    }
                    case 1: {
                        webcursorName = "crosshair";
                        break;
                    }
                    case 13: {
                        webcursorName = "move";
                        break;
                    }
                    case 2: {
                        webcursorName = "text";
                        break;
                    }
                    case 3: {
                        webcursorName = "progress";
                        break;
                    }
                    case 10: 
                    case 11: {
                        webcursorName = "e-resize";
                        break;
                    }
                    case 8: 
                    case 9: {
                        webcursorName = "n-resize";
                        break;
                    }
                    case 5: 
                    case 6: {
                        webcursorName = "se-resize";
                        break;
                    }
                    case 4: 
                    case 7: {
                        webcursorName = "ne-resize";
                        break;
                    }
                    case -1: {
                        webcursorName = cursor.getName();
                        break;
                    }
                    default: {
                        webcursorName = "default";
                    }
                }
            }
            webcursor = cursor;
        } else {
            webcursor = overridenCursorName;
            webcursorName = overridenCursorName.getName();
        }
        String currentCursor = this.getCurrentCursor(winId);
        if (currentCursor != null && !currentCursor.equals(webcursorName)) {
            AppFrameMsgOut f = new AppFrameMsgOut();
            CursorChangeEventMsg cursorChange = new CursorChangeEventMsg(webcursorName);
            cursorChange.setWinId(winId);
            if (webcursor instanceof WebCursor) {
                WebCursor c = (WebCursor)webcursor;
                BufferedImage img = c.getImage();
                cursorChange.setB64img(Services.getImageService().getPngImage(img));
                cursorChange.setX(c.getHotSpot() != null ? c.getHotSpot().x : 0);
                cursorChange.setY(c.getHotSpot() != null ? c.getHotSpot().y : 0);
                File file = Util.convertAndSaveCursor(img, cursorChange.getX(), cursorChange.getY());
                if (file != null) {
                    cursorChange.setCurFile(file.getAbsolutePath());
                }
            }
            f.setCursorChange(cursorChange);
            this.setCurrentCursor(winId, webcursorName);
            Logger.debug("WebPaintDispatcher:notifyCursorUpdate", f);
            this.sendObject(f);
        }
    }

    protected abstract String getCurrentCursor(String var1);

    protected abstract void setCurrentCursor(String var1, String var2);

    protected void validateSelection(JFileChooser fileChooserDialog) {
        if (Boolean.getBoolean("webswing.isolatedFs") && fileChooserDialog != null) {
            try {
                if (fileChooserDialog.getSelectedFile() != null && !IsolatedFsShellFolderManager.isSubfolderOfRoots(fileChooserDialog.getSelectedFile())) {
                    throw new IOException("Invalid selection " + fileChooserDialog.getSelectedFile());
                }
                if (fileChooserDialog.getSelectedFiles() != null && fileChooserDialog.getSelectedFiles().length > 0) {
                    for (File selection : fileChooserDialog.getSelectedFiles()) {
                        if (IsolatedFsShellFolderManager.isSubfolderOfRoots(selection)) continue;
                        throw new IOException("Invalid selection " + selection);
                    }
                }
            }
            catch (IOException e) {
                Logger.error("Selection is outside isolated path", e);
                fileChooserDialog.cancelSelection();
            }
        }
    }

    @Override
    public void notifyAudioEventPlay(AudioClip clip, byte[] data, Float time, Integer loop) {
        AppFrameMsgOut f = new AppFrameMsgOut();
        f.setAudioEvent(new AudioEventMsgOut(clip.getId(), AudioEventMsgOut.AudioEventType.play, data, time, loop));
        Logger.debug("WebPaintDispatcher:notifyAudioEvent play", new Object[0]);
        this.sendObject(f);
        this.registerAudioClip(clip);
    }

    @Override
    public void notifyAudioEventStop(AudioClip clip) {
        AppFrameMsgOut f = new AppFrameMsgOut();
        f.setAudioEvent(new AudioEventMsgOut(clip.getId(), AudioEventMsgOut.AudioEventType.stop));
        Logger.debug("WebPaintDispatcher:notifyAudioEvent stop", new Object[0]);
        this.sendObject(f);
    }

    @Override
    public void notifyAudioEventUpdate(AudioClip clip, Float time, Integer loop) {
        AppFrameMsgOut f = new AppFrameMsgOut();
        f.setAudioEvent(new AudioEventMsgOut(clip.getId(), AudioEventMsgOut.AudioEventType.update, time, loop));
        Logger.debug("WebPaintDispatcher:notifyAudioEvent update", new Object[0]);
        this.sendObject(f);
        this.registerAudioClip(clip);
    }

    @Override
    public void notifyAudioEventDispose(AudioClip clip) {
        AppFrameMsgOut f = new AppFrameMsgOut();
        f.setAudioEvent(new AudioEventMsgOut(clip.getId(), AudioEventMsgOut.AudioEventType.dispose));
        Logger.debug("WebPaintDispatcher:notifyAudioEvent dispose", new Object[0]);
        this.sendObject(f);
        this.registeredAudioClips.remove(clip.getId());
    }

    private void registerAudioClip(AudioClip clip) {
        if (!this.registeredAudioClips.containsKey(clip.getId())) {
            this.registeredAudioClips.put(clip.getId(), new WeakReference<AudioClip>(clip));
            return;
        }
        WeakReference<AudioClip> wr = this.registeredAudioClips.get(clip.getId());
        if (wr == null || wr.get() == null) {
            this.registeredAudioClips.put(clip.getId(), new WeakReference<AudioClip>(clip));
        }
    }

    @Override
    public AudioClip findAudioClip(String id) {
        WeakReference<AudioClip> wr = this.registeredAudioClips.get(id);
        if (wr != null && wr.get() != null) {
            return (AudioClip)wr.get();
        }
        return null;
    }

    @Override
    public void registerFileChooserWindows(JFileChooser chooser, Window parent) {
        if (parent != null) {
            this.registeredFileChooserWindows.put(parent, new WeakReference<JFileChooser>(chooser));
            if (chooser != null) {
                chooser.removeComponentListener(this.fileChooserVisibilityListener);
                chooser.addComponentListener(this.fileChooserVisibilityListener);
                chooser.removeHierarchyListener(this.fileChooserVisibilityListener);
                chooser.addHierarchyListener(this.fileChooserVisibilityListener);
            }
        }
    }

    @Override
    public JFileChooser findRegisteredFileChooser(Window parent) {
        JFileChooser chooser;
        WeakReference<JFileChooser> chooserRef;
        if (parent != null && (chooserRef = this.registeredFileChooserWindows.get(parent)) != null && (chooser = (JFileChooser)chooserRef.get()) != null && SwingUtilities.getWindowAncestor(chooser) == parent) {
            chooser.putClientProperty("webswing.customFileChooser", true);
            return chooser;
        }
        return null;
    }

    private class FileChooserShowingListener
    extends ComponentAdapter
    implements HierarchyListener {
        private FileChooserShowingListener() {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.notifyShow((JFileChooser)e.getComponent());
        }

        private void notifyShow(JFileChooser chooser) {
            if (Util.discoverFileChooser(Util.getWebToolkit().getWindowManager().getActiveWindow()) == chooser) {
                AbstractPaintDispatcher.this.setFileChooserDialog(chooser);
                AbstractPaintDispatcher.this.notifyFileDialogActive();
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            this.notifyHide((JFileChooser)e.getComponent());
        }

        private void notifyHide(JFileChooser chooser) {
            if (AbstractPaintDispatcher.this.getFileChooserDialog() == chooser) {
                Util.getWebToolkit().getPaintDispatcher().notifyFileDialogHidden();
            }
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & 4L) == 4L) {
                if (e.getComponent().isShowing()) {
                    this.notifyShow((JFileChooser)e.getComponent());
                } else {
                    this.notifyHide((JFileChooser)e.getComponent());
                }
            }
        }
    }
}

