/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.audio;

import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import org.webswing.audio.AudioClip;

public class AudioMixer
implements Mixer {
    private static final String INFO_NAME = "Webswing Sound Mixer";
    private static final String INFO_VENDOR = "Webswing";
    private static final String INFO_DESCRIPTION = "Webswing Sound Mixer";
    private static final String INFO_VERSION = "1.0";
    private static final Mixer.Info info = new Info();
    private final Line.Info sourceLineInfo;
    final Object control_mutex = this;
    private AudioFormat format = new AudioFormat(44100.0f, 16, 2, true, false);
    private final float controlrate = 147.0f;
    private final long latency = 100000L;

    public AudioMixer() {
        ArrayList<AudioFormat> formats = new ArrayList<AudioFormat>();
        for (int channels = 1; channels <= 2; ++channels) {
            formats.add(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 8, channels, channels, -1.0f, false));
            formats.add(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 8, channels, channels, -1.0f, false));
            for (int bits = 16; bits < 32; bits += 8) {
                formats.add(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, bits, channels, channels * bits / 8, -1.0f, false));
                formats.add(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, bits, channels, channels * bits / 8, -1.0f, false));
                formats.add(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, bits, channels, channels * bits / 8, -1.0f, true));
                formats.add(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, bits, channels, channels * bits / 8, -1.0f, true));
            }
            formats.add(new AudioFormat(AudioFormat.Encoding.PCM_FLOAT, -1.0f, 32, channels, channels * 4, -1.0f, false));
            formats.add(new AudioFormat(AudioFormat.Encoding.PCM_FLOAT, -1.0f, 32, channels, channels * 4, -1.0f, true));
            formats.add(new AudioFormat(AudioFormat.Encoding.PCM_FLOAT, -1.0f, 64, channels, channels * 8, -1.0f, false));
            formats.add(new AudioFormat(AudioFormat.Encoding.PCM_FLOAT, -1.0f, 64, channels, channels * 8, -1.0f, true));
        }
        AudioFormat[] formats_array = formats.toArray(new AudioFormat[formats.size()]);
        this.sourceLineInfo = new DataLine.Info(Clip.class, formats_array, -1, -1);
    }

    @Override
    public void open() throws LineUnavailableException {
    }

    public void open(SourceDataLine line) throws LineUnavailableException {
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public Control getControl(Control.Type control) {
        throw new IllegalArgumentException("Unsupported control type : " + control);
    }

    @Override
    public Control[] getControls() {
        return new Control[0];
    }

    @Override
    public Line.Info getLineInfo() {
        return new Line.Info(Mixer.class);
    }

    @Override
    public boolean isControlSupported(Control.Type control) {
        return false;
    }

    @Override
    public void addLineListener(LineListener listener) {
    }

    @Override
    public void removeLineListener(LineListener listener) {
    }

    @Override
    public Mixer.Info getMixerInfo() {
        return info;
    }

    @Override
    public Line.Info[] getSourceLineInfo() {
        return new Line.Info[]{this.sourceLineInfo};
    }

    @Override
    public Line.Info[] getSourceLineInfo(Line.Info info) {
        ArrayList<Line.Info> infos = new ArrayList<Line.Info>();
        if (info.matches(this.sourceLineInfo)) {
            infos.add(this.sourceLineInfo);
        }
        return infos.toArray(new Line.Info[infos.size()]);
    }

    @Override
    public Line[] getSourceLines() {
        return new Line[0];
    }

    @Override
    public Line.Info[] getTargetLineInfo() {
        return new Line.Info[0];
    }

    @Override
    public Line.Info[] getTargetLineInfo(Line.Info info) {
        return new Line.Info[0];
    }

    @Override
    public Line[] getTargetLines() {
        return new Line[0];
    }

    @Override
    public boolean isLineSupported(Line.Info info) {
        if (info != null) {
            return info.matches(this.sourceLineInfo);
        }
        return false;
    }

    @Override
    public Line getLine(Line.Info info) throws LineUnavailableException {
        if (!this.isLineSupported(info)) {
            throw new IllegalArgumentException("Line unsupported: " + info);
        }
        if (info.getLineClass() == Clip.class) {
            return new AudioClip(this, (DataLine.Info)info);
        }
        throw new IllegalArgumentException("Line unsupported: " + info);
    }

    @Override
    public int getMaxLines(Line.Info info) {
        if (info.getLineClass() == Clip.class) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean isSynchronizationSupported(Line[] lines, boolean maintainSync) {
        return false;
    }

    @Override
    public void synchronize(Line[] lines, boolean maintainSync) {
        throw new IllegalArgumentException("Synchronization not supported by this mixer.");
    }

    @Override
    public void unsynchronize(Line[] lines) {
        throw new IllegalArgumentException("Synchronization not supported by this mixer.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLatency() {
        Object object = this.control_mutex;
        synchronized (object) {
            return 100000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioFormat getFormat() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.format;
        }
    }

    float getControlRate() {
        return 147.0f;
    }

    private static class Info
    extends Mixer.Info {
        Info() {
            super("Webswing Sound Mixer", AudioMixer.INFO_VENDOR, "Webswing Sound Mixer", AudioMixer.INFO_VERSION);
        }
    }
}

