/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.audio;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import org.webswing.audio.AudioMixer;
import org.webswing.toolkit.util.Util;

public class AudioClip
implements Clip,
DataLine {
    private final String id = System.identityHashCode(this) + "";
    private boolean open;
    private byte[] data;
    private int loopCount;
    private float timePosition = 0.0f;
    private List<LineListener> listeners = new ArrayList<LineListener>();

    public AudioClip(AudioMixer mixer, DataLine.Info info) {
    }

    @Override
    public void open(AudioInputStream stream) throws LineUnavailableException, IOException {
        if (this.isOpen()) {
            throw new IllegalStateException("Clip is already open!");
        }
        byte[] data = AudioClip.toByteArray(stream);
        if (data != null) {
            this.data = Arrays.copyOf(data, data.length);
        }
        this.open = true;
        if (!this.listeners.isEmpty()) {
            LineEvent event = new LineEvent(this, LineEvent.Type.OPEN, this.getLongFramePosition());
            for (LineListener listener : this.listeners) {
                listener.update(event);
            }
        }
    }

    @Override
    public void open(AudioFormat format, byte[] audioData, int offset, int bufferSize) throws LineUnavailableException {
        if (this.isOpen()) {
            throw new IllegalStateException("Clip is already open!");
        }
        this.data = Arrays.copyOf(audioData, audioData.length);
        this.open = true;
        if (!this.listeners.isEmpty()) {
            LineEvent event = new LineEvent(this, LineEvent.Type.OPEN, this.getLongFramePosition());
            for (LineListener listener : this.listeners) {
                listener.update(event);
            }
        }
    }

    @Override
    public void open() throws LineUnavailableException {
        if (this.isOpen()) {
            throw new IllegalStateException("Clip is already open!");
        }
        this.open = true;
        if (!this.listeners.isEmpty()) {
            LineEvent event = new LineEvent(this, LineEvent.Type.OPEN, this.getLongFramePosition());
            for (LineListener listener : this.listeners) {
                listener.update(event);
            }
        }
    }

    @Override
    public void setMicrosecondPosition(long microseconds) {
        this.timePosition = (float)microseconds / 1000000.0f;
        Util.getWebToolkit().getPaintDispatcher().notifyAudioEventUpdate(this, Float.valueOf(this.timePosition), this.loopCount);
    }

    @Override
    public long getMicrosecondPosition() {
        return (long)this.timePosition * 1000000L;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void start() {
        if (!this.isOpen()) {
            return;
        }
        Util.getWebToolkit().getPaintDispatcher().notifyAudioEventPlay(this, this.data, Float.valueOf(this.timePosition), 0);
        if (!this.listeners.isEmpty()) {
            LineEvent event = new LineEvent(this, LineEvent.Type.START, this.getLongFramePosition());
            for (LineListener listener : this.listeners) {
                listener.update(event);
            }
        }
    }

    @Override
    public void loop(int count) {
        if (!this.isOpen()) {
            return;
        }
        this.loopCount = count;
        Util.getWebToolkit().getPaintDispatcher().notifyAudioEventPlay(this, this.data, Float.valueOf(this.timePosition), this.loopCount);
        if (!this.listeners.isEmpty()) {
            LineEvent event = new LineEvent(this, LineEvent.Type.START, this.getLongFramePosition());
            for (LineListener listener : this.listeners) {
                listener.update(event);
            }
        }
    }

    @Override
    public void stop() {
        if (!this.isOpen()) {
            return;
        }
        Util.getWebToolkit().getPaintDispatcher().notifyAudioEventStop(this);
        this.notifyPlaybackStopped();
    }

    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        this.stop();
        this.open = false;
        Util.getWebToolkit().getPaintDispatcher().notifyAudioEventDispose(this);
        if (!this.listeners.isEmpty()) {
            LineEvent event = new LineEvent(this, LineEvent.Type.CLOSE, this.getLongFramePosition());
            for (LineListener listener : this.listeners) {
                listener.update(event);
            }
        }
    }

    @Override
    public void addLineListener(LineListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeLineListener(LineListener listener) {
        this.listeners.remove(listener);
    }

    public String getId() {
        return this.id;
    }

    public void notifyPlaybackStopped() {
        if (!this.listeners.isEmpty()) {
            LineEvent event = new LineEvent(this, LineEvent.Type.STOP, this.getLongFramePosition());
            for (LineListener listener : this.listeners) {
                listener.update(event);
            }
        }
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    @Override
    public int getFrameLength() {
        return -1;
    }

    @Override
    public long getMicrosecondLength() {
        return -1L;
    }

    @Override
    public void setFramePosition(int frames) {
    }

    @Override
    public void setLoopPoints(int start, int end) {
    }

    @Override
    public int available() {
        return -1;
    }

    @Override
    public void drain() {
    }

    @Override
    public void flush() {
    }

    @Override
    public int getBufferSize() {
        return -1;
    }

    @Override
    public AudioFormat getFormat() {
        return null;
    }

    @Override
    public int getFramePosition() {
        return -1;
    }

    @Override
    public float getLevel() {
        return -1.0f;
    }

    @Override
    public long getLongFramePosition() {
        return -1L;
    }

    @Override
    public Line.Info getLineInfo() {
        return null;
    }

    @Override
    public Control[] getControls() {
        return new Control[0];
    }

    @Override
    public boolean isControlSupported(Control.Type control) {
        return false;
    }

    @Override
    public Control getControl(Control.Type control) {
        return null;
    }

    private static byte[] toByteArray(AudioInputStream is) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int reads = is.read();
            while (reads != -1) {
                baos.write(reads);
                reads = is.read();
            }
            is.close();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }
}

