/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util.random;

import java.util.Random;
import org.neuroph.core.Connection;
import org.neuroph.core.Layer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.Neuron;

public class WeightsRandomizer {
    protected Random randomGen;

    public WeightsRandomizer() {
        this.randomGen = new Random();
    }

    public WeightsRandomizer(Random randomGen) {
        this.randomGen = randomGen;
    }

    public Random getRandomGen() {
        return this.randomGen;
    }

    public void randomize(NeuralNetwork<?> neuralNetwork) {
        for (Layer layer : neuralNetwork.getLayers()) {
            this.randomize(layer);
        }
    }

    protected void randomize(Layer layer) {
        for (Neuron neuron : layer.getNeurons()) {
            this.randomize(neuron);
        }
    }

    protected void randomize(Neuron neuron) {
        int numberOfInputConnections = neuron.getInputConnections().size();
        double coefficient = 1.0 / Math.sqrt(numberOfInputConnections);
        coefficient = coefficient == 0.0 ? 1.0 : coefficient;
        for (Connection connection : neuron.getInputConnections()) {
            connection.getWeight().setValue(this.nextRandomWeight());
        }
    }

    protected double nextRandomWeight() {
        return this.randomGen.nextDouble() - 0.5;
    }
}

