/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util.io;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.neuroph.util.io.NeurophInputException;
import org.neuroph.util.io.OutputAdapter;

public class JDBCOutputAdapter
implements OutputAdapter {
    Connection connection;
    String tableName;

    public JDBCOutputAdapter(Connection connection, String tableName) {
        this.connection = connection;
        this.tableName = tableName;
    }

    @Override
    public void writeOutput(double[] output) {
        try {
            String sql = "INSERT " + this.tableName + " VALUES(";
            for (int i = 0; i < output.length; ++i) {
                sql = sql + "?";
                if (i >= output.length - 1) continue;
                sql = ", ";
            }
            sql = sql + ")";
            PreparedStatement stmt = this.connection.prepareStatement(sql);
            for (int i = 0; i < output.length; ++i) {
                stmt.setDouble(i, output[i]);
            }
            stmt.executeUpdate(sql);
            stmt.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(JDBCOutputAdapter.class.getName()).log(Level.SEVERE, null, ex);
            throw new NeurophInputException("Error executing query at JDBCOutputAdapter", ex);
        }
    }

    @Override
    public void close() {
    }
}

