/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.neuroph.core.Neuron;
import org.neuroph.core.exceptions.NeurophException;
import org.neuroph.core.input.InputFunction;
import org.neuroph.core.transfer.TransferFunction;
import org.neuroph.nnet.comp.neuron.InputOutputNeuron;
import org.neuroph.nnet.comp.neuron.ThresholdNeuron;
import org.neuroph.util.NeuronProperties;
import org.neuroph.util.Properties;

public class NeuronFactory {
    private NeuronFactory() {
    }

    public static Neuron createNeuron(NeuronProperties neuronProperties) {
        InputFunction inputFunction = null;
        Class inputFunctionClass = neuronProperties.getInputFunction();
        if (inputFunctionClass != null) {
            inputFunction = NeuronFactory.createInputFunction(inputFunctionClass);
        }
        TransferFunction transferFunction = NeuronFactory.createTransferFunction(neuronProperties.getTransferFunctionProperties());
        Neuron neuron = null;
        Class neuronClass = neuronProperties.getNeuronType();
        try {
            Class[] paramTypes = new Class[]{InputFunction.class, TransferFunction.class};
            Constructor con = neuronClass.getConstructor(paramTypes);
            Object[] paramList = new Object[]{inputFunction, transferFunction};
            neuron = (Neuron)con.newInstance(paramList);
        }
        catch (NoSuchMethodException paramTypes) {
        }
        catch (InstantiationException e) {
            throw new NeurophException("InstantiationException while creating Neuron!", e);
        }
        catch (IllegalAccessException e) {
            throw new NeurophException("IllegalAccessException while creating Neuron!", e);
        }
        catch (InvocationTargetException e) {
            throw new NeurophException("InvocationTargetException while creating Neuron!", e);
        }
        if (neuron == null) {
            try {
                neuron = (Neuron)neuronClass.newInstance();
            }
            catch (IllegalAccessException e) {
                System.err.println("InstantiationException while creating Neuron!");
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                System.err.println("InstantiationException while creating Neuron!");
                e.printStackTrace();
            }
        }
        if (neuronProperties.hasProperty("thresh")) {
            ((ThresholdNeuron)neuron).setThresh((Double)neuronProperties.getProperty("thresh"));
        } else if (neuronProperties.hasProperty("bias")) {
            ((InputOutputNeuron)neuron).setBias((Double)neuronProperties.getProperty("bias"));
        }
        return neuron;
    }

    private static InputFunction createInputFunction(Class inputFunctionClass) {
        InputFunction inputFunction = null;
        try {
            inputFunction = (InputFunction)inputFunctionClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new NeurophException("InstantiationException while creating InputFunction!", e);
        }
        catch (IllegalAccessException e) {
            throw new NeurophException("IllegalAccessException while creating InputFunction!", e);
        }
        return inputFunction;
    }

    private static TransferFunction createTransferFunction(Properties tfProperties) {
        TransferFunction transferFunction = null;
        Class tfClass = (Class)tfProperties.getProperty("transferFunction");
        try {
            Class<?>[] paramTypes = null;
            Constructor<?>[] cons = tfClass.getConstructors();
            for (int i = 0; i < cons.length; ++i) {
                paramTypes = cons[i].getParameterTypes();
                if (paramTypes.length == 1 && paramTypes[0] == Properties.class) {
                    Class[] argTypes = new Class[]{Properties.class};
                    Constructor ct = tfClass.getConstructor(argTypes);
                    Object[] argList = new Object[]{tfProperties};
                    transferFunction = (TransferFunction)ct.newInstance(argList);
                    break;
                }
                if (paramTypes.length != 0) continue;
                transferFunction = (TransferFunction)tfClass.newInstance();
                break;
            }
            return transferFunction;
        }
        catch (NoSuchMethodException e) {
            System.err.println("getConstructor() couldn't find the constructor while creating TransferFunction!");
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            System.err.println("InstantiationException while creating TransferFunction!");
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            System.err.println("No permission to invoke method while creating TransferFunction!");
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            System.err.println("Method threw an: " + e.getTargetException() + " while creating TransferFunction!");
            e.printStackTrace();
        }
        return transferFunction;
    }
}

