/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.samples.mnist.learn;

import java.io.IOException;
import org.neuroph.core.data.DataSet;
import org.neuroph.nnet.learning.BackPropagation;
import org.neuroph.samples.convolution.mnist.MNISTDataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLayerMNIST {
    private static Logger LOG = LoggerFactory.getLogger(MultiLayerMNIST.class);

    public static void main(String[] args) throws IOException {
        int maxIter = 10000;
        double maxError = 0.01;
        double learningRate = 0.2;
        int validationFolds = Integer.parseInt(args[3]);
        int maxLayers = Integer.parseInt(args[4]);
        int minNeuronCount = Integer.parseInt(args[5]);
        int maxNeuronCount = Integer.parseInt(args[6]);
        int neuronIncrement = Integer.parseInt(args[7]);
        LOG.info("MLP learning for MNIST started.....");
        DataSet trainSet = MNISTDataSet.createFromFile("data_sets/train-labels.idx1-ubyte", "data_sets/train-images.idx3-ubyte", 60000);
        DataSet testSet = MNISTDataSet.createFromFile("data_sets/t10k-labels.idx1-ubyte", "data_sets/t10k-images.idx3-ubyte", 10000);
        BackPropagation bp = new BackPropagation();
        bp.setMaxIterations(maxIter);
        bp.setMaxError(maxError);
        bp.setLearningRate(learningRate);
        LOG.info("Evaluating model on Test Set.....");
        LOG.info("MLP learning for MNIST successfully finished.....");
    }
}

