/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.samples.adalineDigits;

import org.neuroph.core.data.DataSetRow;

public class Data {
    public static final int CHAR_WIDTH = 5;
    public static final int CHAR_HEIGHT = 7;
    public static String[][] DIGITS = new String[][]{{" OOO ", "O   O", "O   O", "O   O", "O   O", "O   O", " OOO "}, {"  O  ", " OO  ", "O O  ", "  O  ", "  O  ", "  O  ", "  O  "}, {" OOO ", "O   O", "    O", "   O ", "  O  ", " O   ", "OOOOO"}, {" OOO ", "O   O", "    O", " OOO ", "    O", "O   O", " OOO "}, {"   O ", "  OO ", " O O ", "O  O ", "OOOOO", "   O ", "   O "}, {"OOOOO", "O    ", "O    ", "OOOO ", "    O", "O   O", " OOO "}, {" OOO ", "O   O", "O    ", "OOOO ", "O   O", "O   O", " OOO "}, {"OOOOO", "    O", "    O", "   O ", "  O  ", " O   ", "O    "}, {" OOO ", "O   O", "O   O", " OOO ", "O   O", "O   O", " OOO "}, {" OOO ", "O   O", "O   O", " OOOO", "    O", "O   O", " OOO "}};

    public static DataSetRow convertImageIntoData(String[] image) {
        DataSetRow dataSetRow = new DataSetRow(35.0);
        double[] array = new double[35];
        for (int row = 0; row < 7; ++row) {
            for (int column = 0; column < 5; ++column) {
                int index = row * 5 + column;
                char ch = image[row].charAt(column);
                array[index] = ch == 'O' ? 1 : -1;
            }
        }
        dataSetRow.setInput(array);
        return dataSetRow;
    }

    public static String[] convertDataIntoImage(double[] data) {
        String[] image = new String[data.length / 5];
        String row = "";
        for (int i = 0; i < data.length; ++i) {
            row = data[i] == 1.0 ? row + "O" : row + " ";
            if (row.length() % 5 != 0 || row.length() == 0) continue;
            image[i / 5] = row;
            row = "";
        }
        return image;
    }
}

