/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.samples;

import org.neuroph.core.Connection;
import org.neuroph.core.Layer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.Neuron;
import org.neuroph.nnet.MultiLayerPerceptron;
import org.neuroph.util.random.DistortRandomizer;
import org.neuroph.util.random.NguyenWidrowRandomizer;

public class RandomizationSample {
    public static void main(String[] args) {
        MultiLayerPerceptron neuralNet = new MultiLayerPerceptron(2, 3, 1);
        neuralNet.randomizeWeights(new NguyenWidrowRandomizer(0.3, 0.7));
        RandomizationSample.printWeights(neuralNet);
        neuralNet.randomizeWeights(new DistortRandomizer(0.5));
        RandomizationSample.printWeights(neuralNet);
    }

    public static void printWeights(NeuralNetwork<?> neuralNet) {
        for (Layer layer : neuralNet.getLayers()) {
            for (Neuron neuron : layer.getNeurons()) {
                for (Connection connection : neuron.getInputConnections()) {
                    System.out.print(connection.getWeight().value + " ");
                }
                System.out.println();
            }
        }
    }
}

