/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.samples;

import java.util.Arrays;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;
import org.neuroph.core.events.LearningEvent;
import org.neuroph.core.events.LearningEventListener;
import org.neuroph.nnet.RBFNetwork;
import org.neuroph.nnet.learning.LMS;
import org.neuroph.nnet.learning.RBFLearning;

public class RBFClassificationSample
implements LearningEventListener {
    public static void main(String[] args) {
        new RBFClassificationSample().run();
    }

    public void run() {
        String inputFileName = "data_sets/sine.csv";
        RBFNetwork neuralNet = new RBFNetwork(1, 15, 1);
        DataSet dataSet = DataSet.createFromFile(inputFileName, 1, 1, ",", false);
        RBFLearning learningRule = (RBFLearning)neuralNet.getLearningRule();
        learningRule.setLearningRate(0.02);
        learningRule.setMaxError(0.01);
        learningRule.addListener(this);
        neuralNet.learn(dataSet);
        System.out.println("Done training.");
        System.out.println("Testing network...");
        this.testNeuralNetwork(neuralNet, dataSet);
    }

    public void testNeuralNetwork(NeuralNetwork neuralNet, DataSet testSet) {
        for (DataSetRow testSetRow : testSet.getRows()) {
            neuralNet.setInput(testSetRow.getInput());
            neuralNet.calculate();
            double[] networkOutput = neuralNet.getOutput();
            System.out.print("Input: " + Arrays.toString(testSetRow.getInput()));
            System.out.println(" Output: " + Arrays.toString(networkOutput));
        }
    }

    @Override
    public void handleLearningEvent(LearningEvent event) {
        LMS lr = (LMS)event.getSource();
        System.out.println(lr.getCurrentIteration() + ". iteration | Total network error: " + lr.getTotalNetworkError());
    }
}

