/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.samples;

import java.io.File;
import java.io.FileNotFoundException;
import org.neuroph.core.data.BufferedDataSet;
import org.neuroph.core.events.LearningEvent;
import org.neuroph.core.events.LearningEventListener;
import org.neuroph.nnet.MultiLayerPerceptron;
import org.neuroph.nnet.learning.BackPropagation;

public class BufferedDataSetSample
implements LearningEventListener {
    public static void main(String[] args) throws FileNotFoundException {
        new BufferedDataSetSample().run();
    }

    public void run() throws FileNotFoundException {
        String inputFileName = BufferedDataSetSample.class.getResource("data/iris_data_normalised.txt").getFile();
        MultiLayerPerceptron neuralNet = new MultiLayerPerceptron(4, 16, 3);
        BufferedDataSet irisDataSet = new BufferedDataSet(new File(inputFileName), 4, 3, ",");
        ((BackPropagation)neuralNet.getLearningRule()).addListener(this);
        neuralNet.learn(irisDataSet);
    }

    @Override
    public void handleLearningEvent(LearningEvent event) {
        BackPropagation bp = (BackPropagation)event.getSource();
        System.out.println(bp.getCurrentIteration() + ". iteration : " + bp.getTotalNetworkError());
    }
}

