/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.learning.kmeans;

import java.util.ArrayList;
import java.util.Collections;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;
import org.neuroph.nnet.learning.kmeans.Cluster;
import org.neuroph.nnet.learning.kmeans.KVector;

public class KMeansClustering {
    private DataSet dataSet;
    private KVector[] dataVectors;
    private int numberOfClusters;
    private Cluster[] clusters;
    StringBuilder log = new StringBuilder();

    public KMeansClustering(DataSet dataSet) {
        this.dataSet = dataSet;
        this.dataVectors = new KVector[dataSet.size()];
        this.dataVectors = new KVector[dataSet.size()];
        int i = 0;
        for (DataSetRow row : dataSet.getRows()) {
            KVector vector;
            this.dataVectors[i] = vector = new KVector(row.getInput());
            ++i;
        }
    }

    public KMeansClustering(DataSet dataSet, int numberOfClusters) {
        this.dataSet = dataSet;
        this.numberOfClusters = numberOfClusters;
        this.dataVectors = new KVector[dataSet.size()];
        int i = 0;
        for (DataSetRow row : dataSet.getRows()) {
            KVector vector;
            this.dataVectors[i] = vector = new KVector(row.getInput());
            ++i;
        }
    }

    public void initClusters() {
        int i;
        ArrayList<Integer> idxList = new ArrayList<Integer>();
        for (i = 0; i < this.dataSet.size(); ++i) {
            idxList.add(i);
        }
        Collections.shuffle(idxList);
        this.clusters = new Cluster[this.numberOfClusters];
        for (i = 0; i < this.numberOfClusters; ++i) {
            this.clusters[i] = new Cluster();
            int randomIdx = (Integer)idxList.get(i);
            KVector randomVector = this.dataVectors[randomIdx];
            this.clusters[i].setCentroid(randomVector);
        }
    }

    private Cluster getNearestCluster(KVector vector) {
        Cluster nearestCluster = null;
        double minimumDistanceFromCluster = Double.MAX_VALUE;
        double distanceFromCluster = 0.0;
        for (Cluster cluster : this.clusters) {
            distanceFromCluster = vector.distanceFrom(cluster.getCentroid());
            if (!(distanceFromCluster < minimumDistanceFromCluster)) continue;
            minimumDistanceFromCluster = distanceFromCluster;
            nearestCluster = cluster;
        }
        return nearestCluster;
    }

    public void doClustering() {
        boolean clustersChanged;
        if (this.numberOfClusters <= 0) {
            throw new RuntimeException("Error: Number of clusters must be greater then zero!");
        }
        this.initClusters();
        for (KVector vector : this.dataVectors) {
            Cluster nearestCluster = this.getNearestCluster(vector);
            nearestCluster.assignVector(vector);
        }
        do {
            clustersChanged = false;
            this.recalculateCentroids();
            for (KVector vector : this.dataVectors) {
                Cluster nearestCluster = this.getNearestCluster(vector);
                if (vector.getCluster().equals(nearestCluster)) continue;
                nearestCluster.assignVector(vector);
                clustersChanged = true;
            }
        } while (clustersChanged);
    }

    private void recalculateCentroids() {
        for (Cluster cluster : this.clusters) {
            if (cluster.size() <= 0) continue;
            double[] avgSum = cluster.getAvgSum();
            cluster.getCentroid().setValues(avgSum);
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet vectors) {
        this.dataSet = vectors;
    }

    public void setNumberOfClusters(int numberOfClusters) {
        this.numberOfClusters = numberOfClusters;
    }

    public Cluster[] getClusters() {
        return this.clusters;
    }

    public String getLog() {
        return this.log.toString();
    }
}

