/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.learning;

import java.util.List;
import org.neuroph.core.Connection;
import org.neuroph.core.Layer;
import org.neuroph.core.Neuron;
import org.neuroph.nnet.comp.layer.ConvolutionalLayer;
import org.neuroph.nnet.learning.MomentumBackpropagation;

public class ConvolutionalBackpropagation
extends MomentumBackpropagation {
    private static final long serialVersionUID = -7134947805154423695L;

    @Override
    protected void calculateErrorAndUpdateHiddenNeurons() {
        List<Layer> layers = this.neuralNetwork.getLayers();
        for (int layerIdx = layers.size() - 2; layerIdx > 0; --layerIdx) {
            for (Neuron neuron : layers.get(layerIdx).getNeurons()) {
                double neuronError = this.calculateHiddenNeuronError(neuron);
                neuron.setDelta(neuronError);
                if (!(layers.get(layerIdx) instanceof ConvolutionalLayer)) continue;
                this.calculateWeightChanges(neuron);
            }
        }
    }

    @Override
    protected double calculateHiddenNeuronError(Neuron neuron) {
        if (neuron.getParentLayer() instanceof ConvolutionalLayer) {
            return super.calculateHiddenNeuronError(neuron);
        }
        double deltaSum = 0.0;
        for (Connection connection : neuron.getOutConnections()) {
            double delta = connection.getToNeuron().getDelta() * connection.getWeight().value;
            deltaSum += delta;
        }
        return deltaSum;
    }
}

