/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.learning;

import java.util.List;
import org.neuroph.core.Neuron;
import org.neuroph.nnet.comp.neuron.ThresholdNeuron;
import org.neuroph.nnet.learning.PerceptronLearning;

public class BinaryDeltaRule
extends PerceptronLearning {
    private static final long serialVersionUID = 1L;
    private double errorCorrection = 0.1;

    @Override
    protected void calculateWeightChanges(double[] patternError) {
        int i = 0;
        List<Neuron> outputNeurons = this.neuralNetwork.getOutputNeurons();
        for (Neuron outputNeuron : outputNeurons) {
            ThresholdNeuron neuron = (ThresholdNeuron)outputNeuron;
            double outErr = patternError[i];
            double thresh = neuron.getThresh();
            double netInput = neuron.getNetInput();
            double threshError = thresh - netInput;
            double neuronError = outErr * (Math.abs(threshError) + this.errorCorrection);
            neuron.setDelta(neuronError);
            this.calculateWeightChanges(neuron);
            ++i;
        }
    }

    public double getErrorCorrection() {
        return this.errorCorrection;
    }

    public void setErrorCorrection(double errorCorrection) {
        this.errorCorrection = errorCorrection;
    }
}

