/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.comp.layer;

import org.neuroph.core.Neuron;
import org.neuroph.core.Weight;
import org.neuroph.core.input.Max;
import org.neuroph.core.transfer.Tanh;
import org.neuroph.nnet.comp.Dimension2D;
import org.neuroph.nnet.comp.Kernel;
import org.neuroph.nnet.comp.layer.FeatureMapLayer;
import org.neuroph.nnet.comp.layer.FeatureMapsLayer;
import org.neuroph.util.ConnectionFactory;
import org.neuroph.util.NeuronProperties;

public class PoolingLayer
extends FeatureMapsLayer {
    private static final long serialVersionUID = -6771501759374920878L;
    private Kernel kernel;
    public static final NeuronProperties DEFAULT_NEURON_PROP = new NeuronProperties();

    public PoolingLayer(FeatureMapsLayer fromLayer, Dimension2D kernelDim) {
        this.kernel = new Kernel(kernelDim);
        int numberOfMaps = fromLayer.getNumberOfMaps();
        Dimension2D fromDimension = fromLayer.getMapDimensions();
        int mapWidth = fromDimension.getWidth() / this.kernel.getWidth();
        int mapHeight = fromDimension.getHeight() / this.kernel.getHeight();
        this.mapDimensions = new Dimension2D(mapWidth, mapHeight);
        this.createFeatureMaps(numberOfMaps, this.mapDimensions, kernelDim, DEFAULT_NEURON_PROP);
    }

    public PoolingLayer(FeatureMapsLayer fromLayer, Dimension2D kernelDim, int numberOfMaps, NeuronProperties neuronProp) {
        this.kernel = this.kernel;
        Dimension2D fromDimension = fromLayer.getMapDimensions();
        int mapWidth = fromDimension.getWidth() / this.kernel.getWidth();
        int mapHeight = fromDimension.getHeight() / this.kernel.getHeight();
        this.mapDimensions = new Dimension2D(mapWidth, mapHeight);
        this.createFeatureMaps(numberOfMaps, this.mapDimensions, kernelDim, neuronProp);
    }

    @Override
    public void connectMaps(FeatureMapLayer fromMap, FeatureMapLayer toMap) {
        int kernelWidth = this.kernel.getWidth();
        int kernelHeight = this.kernel.getHeight();
        Weight weight = new Weight(1.0);
        for (int x = 0; x < fromMap.getWidth() - kernelWidth + 1; x += kernelWidth) {
            for (int y = 0; y < fromMap.getHeight() - kernelHeight + 1; y += kernelHeight) {
                Neuron toNeuron = toMap.getNeuronAt(x / kernelWidth, y / kernelHeight);
                for (int dy = 0; dy < kernelHeight; ++dy) {
                    for (int dx = 0; dx < kernelWidth; ++dx) {
                        int fromX = x + dx;
                        int fromY = y + dy;
                        Neuron fromNeuron = fromMap.getNeuronAt(fromX, fromY);
                        ConnectionFactory.createConnection(fromNeuron, toNeuron, weight);
                    }
                }
            }
        }
    }

    static {
        DEFAULT_NEURON_PROP.setProperty("useBias", true);
        DEFAULT_NEURON_PROP.setProperty("transferFunction", Tanh.class);
        DEFAULT_NEURON_PROP.setProperty("inputFunction", Max.class);
    }
}

