/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.samples;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.data.DataSet;
import org.neuroph.imgrec.ColorMode;
import org.neuroph.imgrec.FractionRgbData;
import org.neuroph.imgrec.ImageRecognitionHelper;
import org.neuroph.imgrec.image.Dimension;
import org.neuroph.nnet.learning.MomentumBackpropagation;
import org.neuroph.util.TransferFunctionType;

public class RGBImageRecognitionTrainingSample {
    public static void main(String[] args) throws IOException {
        String imageDir = "/home/zoran/Downloads/MihailoHSLTest/trening";
        ArrayList<String> imageLabels = new ArrayList<String>();
        imageLabels.add("bird");
        imageLabels.add("cat");
        imageLabels.add("dog");
        Map<String, FractionRgbData> map = ImageRecognitionHelper.getFractionRgbDataForDirectory(new File(imageDir), new Dimension(20, 20));
        DataSet dataSet = ImageRecognitionHelper.createRGBTrainingSet(imageLabels, map);
        ArrayList<Integer> hiddenLayers = new ArrayList<Integer>();
        hiddenLayers.add(12);
        NeuralNetwork nnet = ImageRecognitionHelper.createNewNeuralNetwork("someNetworkName", new Dimension(20, 20), ColorMode.COLOR_RGB, imageLabels, hiddenLayers, TransferFunctionType.SIGMOID);
        MomentumBackpropagation mb = (MomentumBackpropagation)nnet.getLearningRule();
        mb.setLearningRate(0.2);
        mb.setMaxError(0.9);
        mb.setMomentum(1.0);
        System.out.println("NNet start learning...");
        nnet.learn(dataSet);
        System.out.println("NNet learned");
    }
}

