/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;

public class UnsharpMaskingFilter
implements ImageFilter,
Serializable {
    private transient BufferedImage originalImage;
    private transient BufferedImage filteredImage;

    @Override
    public BufferedImage processImage(BufferedImage image) {
        this.originalImage = image;
        BufferedImage bluredImage = this.getBluredImage();
        BufferedImage unsharpMask = this.getUnsharpMask(this.originalImage, bluredImage);
        this.filteredImage = this.getSharpImage(this.originalImage, unsharpMask);
        return this.filteredImage;
    }

    public BufferedImage getBluredImage() {
        int width = this.originalImage.getWidth();
        int height = this.originalImage.getHeight();
        BufferedImage bluredImage = new BufferedImage(width, height, this.originalImage.getType());
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int newColor = this.getAverageBluring(i, j);
                int alpha = new Color(this.originalImage.getRGB(i, j)).getAlpha();
                int rgb = ImageUtilities.colorToRGB(alpha, newColor, newColor, newColor);
                bluredImage.setRGB(i, j, rgb);
            }
        }
        return bluredImage;
    }

    public int getAverageBluring(int i, int j) {
        double sum = 0.0;
        int n = 0;
        for (int x = i - 1; x <= i + 1; ++x) {
            for (int y = j - 1; y <= j + 1; ++y) {
                if (x < 0 || x >= this.originalImage.getWidth() || y < 0 || y >= this.originalImage.getHeight()) continue;
                int color = new Color(this.originalImage.getRGB(x, y)).getRed();
                sum += (double)color;
                ++n;
            }
        }
        int average = (int)Math.round(sum / (double)n);
        return average;
    }

    public BufferedImage getUnsharpMask(BufferedImage originalImage, BufferedImage bluredImage) {
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        BufferedImage unsharpMask = new BufferedImage(width, height, originalImage.getType());
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int originalColor = new Color(originalImage.getRGB(i, j)).getRed();
                int blurColor = new Color(bluredImage.getRGB(i, j)).getRed();
                int alpha = new Color(originalImage.getRGB(i, j)).getAlpha();
                int newColor = originalColor - blurColor;
                int rgb = ImageUtilities.colorToRGB(alpha, newColor, newColor, newColor);
                unsharpMask.setRGB(i, j, rgb);
            }
        }
        return unsharpMask;
    }

    public BufferedImage getSharpImage(BufferedImage originalImage, BufferedImage unsharpMask) {
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        BufferedImage sharpImage = new BufferedImage(width, height, originalImage.getType());
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int originalColor = new Color(originalImage.getRGB(i, j)).getRed();
                int unsharpColor = new Color(unsharpMask.getRGB(i, j)).getRed();
                int alpha = new Color(originalImage.getRGB(i, j)).getAlpha();
                int newColor = originalColor + unsharpColor;
                int rgb = ImageUtilities.colorToRGB(alpha, newColor, newColor, newColor);
                sharpImage.setRGB(i, j, rgb);
            }
        }
        return sharpImage;
    }

    public String toString() {
        return "Unsharp Masking Filter";
    }
}

