/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Arrays;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;

public class MedianFilter
implements ImageFilter,
Serializable {
    private transient BufferedImage originalImage;
    private transient BufferedImage filteredImage;
    private int radius = 1;

    @Override
    public BufferedImage processImage(BufferedImage image) {
        this.originalImage = image;
        int width = this.originalImage.getWidth();
        int height = this.originalImage.getHeight();
        this.filteredImage = new BufferedImage(width, height, this.originalImage.getType());
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int[] arrayOfPixels = this.getArrayOfPixels(i, j);
                int median = this.findMedian(arrayOfPixels);
                int alpha = new Color(this.originalImage.getRGB(i, j)).getAlpha();
                int newColor = ImageUtilities.colorToRGB(alpha, median, median, median);
                this.filteredImage.setRGB(i, j, newColor);
            }
        }
        return this.filteredImage;
    }

    public int[] getArrayOfPixels(int i, int j) {
        int startX = i - this.radius;
        int goalX = i + this.radius;
        int startY = j - this.radius;
        int goalY = j + this.radius;
        if (startX < 0) {
            startX = 0;
        }
        if (goalX > this.originalImage.getWidth() - 1) {
            goalX = this.originalImage.getWidth() - 1;
        }
        if (startY < 0) {
            startY = 0;
        }
        if (goalY > this.originalImage.getHeight() - 1) {
            goalY = this.originalImage.getHeight() - 1;
        }
        int arraySize = (goalX - startX + 1) * (goalY - startY + 1);
        int[] pixels = new int[arraySize];
        int position = 0;
        for (int p = startX; p <= goalX; ++p) {
            for (int q = startY; q <= goalY; ++q) {
                int color;
                pixels[position] = color = new Color(this.originalImage.getRGB(p, q)).getRed();
                ++position;
            }
        }
        return pixels;
    }

    public int findMedian(int[] arrayOfPixels) {
        Arrays.sort(arrayOfPixels);
        int middle = arrayOfPixels.length / 2;
        return arrayOfPixels[middle];
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public int getRadius() {
        return this.radius;
    }

    public String toString() {
        return "Median Filter";
    }
}

