/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;

public class GuoHallThiningFilter
implements ImageFilter {
    private BufferedImage originalImage;
    private BufferedImage filteredImage;
    private boolean blackLetters = true;
    int[][] imageM;
    int width;
    int height;

    @Override
    public BufferedImage processImage(BufferedImage image) {
        boolean same;
        int j;
        this.originalImage = image;
        this.width = this.originalImage.getWidth();
        this.height = this.originalImage.getHeight();
        this.filteredImage = new BufferedImage(this.width, this.height, this.originalImage.getType());
        this.imageM = new int[this.width][this.height];
        for (int i = 0; i < this.width; ++i) {
            for (j = 0; j < this.height; ++j) {
                int col = new Color(this.originalImage.getRGB(i, j)).getRed();
                this.imageM[i][j] = this.blackLetters ? 1 - col / 255 : col / 255;
            }
        }
        block2: do {
            int[][] start = new int[this.width][this.height];
            for (int i = 0; i < this.width; ++i) {
                for (int j2 = 0; j2 < this.height; ++j2) {
                    start[i][j2] = this.imageM[i][j2];
                }
            }
            this.thiningGuoHallIteration(0);
            this.thiningGuoHallIteration(1);
            same = true;
            for (int i = 0; i < this.width; ++i) {
                for (int j3 = 0; j3 < this.height; ++j3) {
                    if (start[i][j3] == this.imageM[i][j3]) continue;
                    same = false;
                    continue block2;
                }
            }
        } while (!same);
        for (int i = 0; i < this.width; ++i) {
            for (j = 0; j < this.height; ++j) {
                int alpha = new Color(this.originalImage.getRGB(i, j)).getAlpha();
                int col = this.blackLetters ? 255 - this.imageM[i][j] * 255 : this.imageM[i][j] * 255;
                int rgb = ImageUtilities.colorToRGB(alpha, col, col, col);
                this.filteredImage.setRGB(i, j, rgb);
            }
        }
        return this.filteredImage;
    }

    public String toString() {
        return "Guo Hall Thin Method";
    }

    public void thiningGuoHallIteration(int iter) {
        int j;
        int i;
        int[][] marker = new int[this.width][this.height];
        for (i = 1; i < this.width - 1; ++i) {
            for (j = 1; j < this.height - 1; ++j) {
                int m;
                int p2 = this.imageM[i - 1][j];
                int p3 = this.imageM[i - 1][j + 1];
                int p4 = this.imageM[i][j + 1];
                int p5 = this.imageM[i + 1][j + 1];
                int p6 = this.imageM[i + 1][j];
                int p7 = this.imageM[i + 1][j - 1];
                int p8 = this.imageM[i][j - 1];
                int p9 = this.imageM[i - 1][j - 1];
                int C = (~p2 & (p3 | p4)) + (~p4 & (p5 | p6)) + (~p6 & (p7 | p8)) + (~p8 & (p9 | p2));
                int N1 = (p9 | p2) + (p3 | p4) + (p5 | p6) + (p7 | p8);
                int N2 = (p2 | p3) + (p4 | p5) + (p6 | p7) + (p8 | p9);
                int N = N1 < N2 ? N1 : N2;
                int n = m = iter == 0 ? (p6 | p7 | ~p9) & p8 : (p2 | p3 | ~p5) & p4;
                if (C != 1 || !((N >= 2 && N <= 3) & m == 0)) continue;
                marker[i][j] = 1;
            }
        }
        for (i = 0; i < this.width; ++i) {
            for (j = 0; j < this.height; ++j) {
                int tmp = 1 - marker[i][j];
                this.imageM[i][j] = this.imageM[i][j] == tmp && this.imageM[i][j] == 1 ? 1 : 0;
            }
        }
    }

    public void setBlackLetters(boolean blackLetters) {
        this.blackLetters = blackLetters;
    }
}

