/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;

public class GrayscaleFilter
implements ImageFilter,
Serializable {
    private transient BufferedImage originalImage;
    private transient BufferedImage filteredImage;

    @Override
    public BufferedImage processImage(BufferedImage image) {
        this.originalImage = image;
        int width = this.originalImage.getWidth();
        int height = this.originalImage.getHeight();
        this.filteredImage = new BufferedImage(width, height, this.originalImage.getType());
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int alpha = new Color(this.originalImage.getRGB(i, j)).getAlpha();
                int red = new Color(this.originalImage.getRGB(i, j)).getRed();
                int green = new Color(this.originalImage.getRGB(i, j)).getGreen();
                int blue = new Color(this.originalImage.getRGB(i, j)).getBlue();
                int gray = (int)(0.21 * (double)red + 0.71 * (double)green + 0.07 * (double)blue);
                gray = ImageUtilities.colorToRGB(alpha, gray, gray, gray);
                this.filteredImage.setRGB(i, j, gray);
            }
        }
        return this.filteredImage;
    }

    public String toString() {
        return "Grayscale Filter";
    }
}

