/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.eval.classification;

import java.util.ArrayList;
import org.neuroph.eval.classification.ConfusionMatrix;

public final class ClassificationMetrics {
    double truePositive;
    double trueNegative;
    double falsePositive;
    double falseNegative;
    double correlationCoefficient;
    double total;
    String classLabel;

    public ClassificationMetrics(int truePositive, int trueNegative, int falsePositive, int falseNegative) {
        this.truePositive = truePositive;
        this.trueNegative = trueNegative;
        this.falsePositive = falsePositive;
        this.falseNegative = falseNegative;
        this.total = falseNegative + falsePositive + trueNegative + truePositive;
    }

    public String getClassLabel() {
        return this.classLabel;
    }

    public void setClassLabel(String classLabel) {
        this.classLabel = classLabel;
    }

    public double getAccuracy() {
        return (this.truePositive + this.trueNegative) / this.total;
    }

    public double getErrorRate() {
        return (this.falsePositive + this.falseNegative) / this.total;
    }

    public double getPrecision() {
        return this.truePositive / (this.truePositive + this.falsePositive);
    }

    public double getSensitivity() {
        return this.truePositive / (this.truePositive + this.falseNegative);
    }

    public double getRecall() {
        return this.getSensitivity();
    }

    public double getSpecificity() {
        return this.trueNegative / (this.trueNegative + this.falsePositive);
    }

    public double getTotal() {
        return this.total;
    }

    public double getFalsePositiveRate() {
        return this.falsePositive / (this.falsePositive + this.trueNegative);
    }

    public double getFalseNegativeRate() {
        return this.falseNegative / (this.falseNegative + this.truePositive);
    }

    public double getFalseDiscoveryRate() {
        return this.falsePositive / (this.truePositive + this.falsePositive);
    }

    public double getMatthewsCorrelationCoefficient() {
        return (this.truePositive * this.trueNegative - this.falsePositive * this.falseNegative) / Math.sqrt((this.truePositive + this.falsePositive) * (this.truePositive + this.falseNegative) * (this.trueNegative + this.falsePositive) * (this.trueNegative + this.falseNegative));
    }

    public double getFMeasure() {
        return this.getFMeasure(1);
    }

    public double getFMeasure(int beta) {
        double f = (double)(beta * beta + 1) * this.getPrecision() * this.getSensitivity() / ((double)(beta * beta) * this.getPrecision() + this.getSensitivity());
        if (Double.isNaN(f)) {
            return 0.0;
        }
        return f;
    }

    public double getQ9() {
        if (this.truePositive + this.falseNegative == 0.0) {
            return (this.trueNegative - this.falsePositive) / (this.trueNegative + this.falsePositive);
        }
        if (this.trueNegative + this.falsePositive == 0.0) {
            return (this.truePositive - this.falseNegative) / (this.truePositive + this.falseNegative);
        }
        return 1.0 - Math.sqrt(2.0) * Math.sqrt(Math.pow(this.falseNegative / (this.truePositive + this.falseNegative), 2.0) + Math.pow(this.falsePositive / (this.trueNegative + this.falsePositive), 2.0));
    }

    public double getBalancedClassificationRate() {
        if (this.trueNegative == 0.0 && this.falsePositive == 0.0) {
            return this.truePositive / (this.truePositive + this.falseNegative);
        }
        if (this.truePositive == 0.0 && this.falseNegative == 0.0) {
            return this.trueNegative / (this.trueNegative + this.falsePositive);
        }
        return 0.5 * (this.truePositive / (this.truePositive + this.falseNegative) + this.trueNegative / (this.trueNegative + this.falsePositive));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Class: " + this.classLabel).append("\n");
        sb.append("Total items: ").append(this.getTotal()).append("\n");
        sb.append("True positive:").append(this.truePositive).append("\n");
        sb.append("True negative:").append(this.trueNegative).append("\n");
        sb.append("False positive:").append(this.falsePositive).append("\n");
        sb.append("False negative:").append(this.falseNegative).append("\n");
        sb.append("Accuracy (ACC): ").append(this.getAccuracy()).append("\n");
        sb.append("Sensitivity or true positive rate (TPR): ").append(this.getSensitivity()).append("\n");
        sb.append("Specificity (SPC) or true negative rate (TNR): ").append(this.getSpecificity()).append("\n");
        sb.append("Fall-out or false positive rate (FPR): ").append(this.getFalsePositiveRate()).append("\n");
        sb.append("False negative rate (FNR): ").append(this.getFalseNegativeRate()).append("\n");
        sb.append("Precision or positive predictive value (PPV): ").append(this.getPrecision()).append("\n");
        sb.append("Recall: ").append(this.getSensitivity()).append("\n");
        sb.append("F-measure: ").append(this.getFMeasure()).append("\n");
        sb.append("False discovery rate (FDR): ").append(this.getFalseDiscoveryRate()).append("\n");
        sb.append("Matthews correlation Coefficient (MCC): ").append(this.getMatthewsCorrelationCoefficient()).append("\n");
        return sb.toString();
    }

    public static ClassificationMetrics[] createFromMatrix(ConfusionMatrix confusionMatrix) {
        int classCount = confusionMatrix.getClassCount();
        if (classCount == 2) {
            ClassificationMetrics[] measures = new ClassificationMetrics[1];
            String[] classLabels = confusionMatrix.getClassLabels();
            int tp = confusionMatrix.get(0, 0);
            int tn = confusionMatrix.get(1, 1);
            int fp = confusionMatrix.get(1, 0);
            int fn = confusionMatrix.get(0, 1);
            measures[0] = new ClassificationMetrics(tp, tn, fp, fn);
            measures[0].setClassLabel(classLabels[0]);
            return measures;
        }
        ClassificationMetrics[] measures = new ClassificationMetrics[classCount];
        String[] classLabels = confusionMatrix.getClassLabels();
        for (int clsIdx = 0; clsIdx < confusionMatrix.getClassCount(); ++clsIdx) {
            int tp = confusionMatrix.getTruePositive(clsIdx);
            int tn = confusionMatrix.getTrueNegative(clsIdx);
            int fp = confusionMatrix.getFalsePositive(clsIdx);
            int fn = confusionMatrix.getFalseNegative(clsIdx);
            measures[clsIdx] = new ClassificationMetrics(tp, tn, fp, fn);
            measures[clsIdx].setClassLabel(classLabels[clsIdx]);
        }
        return measures;
    }

    public static Stats average(ClassificationMetrics[] results) {
        ArrayList<String> classLabels = new ArrayList<String>();
        Stats average = new Stats();
        double count = 0.0;
        for (ClassificationMetrics cm : results) {
            average.accuracy += cm.getAccuracy();
            average.precision += cm.getPrecision();
            average.recall += cm.getSensitivity();
            average.fScore += cm.getFMeasure();
            if (classLabels.contains(cm.getClassLabel())) continue;
            classLabels.add(cm.getClassLabel());
        }
        count += 1.0;
        average.accuracy /= (count *= (double)classLabels.size());
        average.precision /= count;
        average.recall /= count;
        average.fScore /= count;
        average.mserror /= count;
        return average;
    }

    public static class Stats {
        public double accuracy = 0.0;
        public double precision = 0.0;
        public double recall = 0.0;
        public double fScore = 0.0;
        public double mserror = 0.0;
        public double correlationCoefficient = 0.0;

        public String toString() {
            return "Stats{accuracy=" + this.accuracy + ", precision=" + this.precision + ", recall=" + this.recall + ", fScore=" + this.fScore + ", mserror=" + this.mserror + ", corelationCoefficient=" + this.correlationCoefficient + '}';
        }
    }
}

