/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.core.learning.error;

import java.io.Serializable;
import org.neuroph.core.learning.error.ErrorFunction;

public final class MeanSquaredError
implements ErrorFunction,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient double totalError;
    private transient float patternCount;

    public MeanSquaredError() {
        this.reset();
    }

    @Override
    public double[] addPatternError(double[] predictedOutput, double[] targetOutput) {
        double[] patternError = new double[targetOutput.length];
        for (int i = 0; i < predictedOutput.length; ++i) {
            patternError[i] = predictedOutput[i] - targetOutput[i];
            this.totalError += patternError[i] * patternError[i];
        }
        this.patternCount += 1.0f;
        return patternError;
    }

    @Override
    public void reset() {
        this.totalError = 0.0;
        this.patternCount = 0.0f;
    }

    @Override
    public double getTotalError() {
        return this.totalError / (double)(2.0f * this.patternCount);
    }
}

