/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.samples;

import java.text.NumberFormat;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;
import org.neuroph.core.events.LearningEvent;
import org.neuroph.core.events.LearningEventListener;
import org.neuroph.core.learning.LearningRule;
import org.neuroph.core.learning.SupervisedLearning;
import org.neuroph.nnet.MultiLayerPerceptron;
import org.neuroph.util.Neuroph;
import org.neuroph.util.TransferFunctionType;

public class SunSpots
implements LearningEventListener {
    public static final double[] SUNSPOTS = new double[]{0.0262, 0.0575, 0.0837, 0.1203, 0.1883, 0.3033, 0.1517, 0.1046, 0.0523, 0.0418, 0.0157, 0.0, 0.0, 0.0105, 0.0575, 0.1412, 0.2458, 0.3295, 0.3138, 0.204, 0.1464, 0.136, 0.1151, 0.0575, 0.1098, 0.2092, 0.4079, 0.6381, 0.5387, 0.3818, 0.2458, 0.1831, 0.0575, 0.0262, 0.0837, 0.1778, 0.3661, 0.4236, 0.5805, 0.5282, 0.3818, 0.2092, 0.1046, 0.0837, 0.0262, 0.0575, 0.1151, 0.2092, 0.3138, 0.4231, 0.4362, 0.2495, 0.25, 0.1606, 0.0638, 0.0502, 0.0534, 0.17, 0.2489, 0.2824, 0.329, 0.4493, 0.3201, 0.2359, 0.1904, 0.1093, 0.0596, 0.1977, 0.3651, 0.5549, 0.5272, 0.4268, 0.3478, 0.182, 0.16, 0.0366, 0.1036, 0.4838, 0.8075, 0.6585, 0.4435, 0.3562, 0.2014, 0.1192, 0.0534, 0.126, 0.4336, 0.6904, 0.6846, 0.6177, 0.4702, 0.3483, 0.3138, 0.2453, 0.2144, 0.1114, 0.0837, 0.0335, 0.0214, 0.0356, 0.0758, 0.1778, 0.2354, 0.2254, 0.2484, 0.2207, 0.147, 0.0528, 0.0424, 0.0131, 0.0, 0.0073, 0.0262, 0.0638, 0.0727, 0.1851, 0.2395, 0.215, 0.1574, 0.125, 0.0816, 0.0345, 0.0209, 0.0094, 0.0445, 0.0868, 0.1898, 0.2594, 0.3358, 0.3504, 0.3708, 0.25, 0.1438, 0.0445, 0.069, 0.2976, 0.6354, 0.7233, 0.5397, 0.4482, 0.3379, 0.1919, 0.1266, 0.056, 0.0785, 0.2097, 0.3216, 0.5152, 0.6522, 0.5036, 0.3483, 0.3373, 0.2829, 0.204, 0.1077, 0.035, 0.0225, 0.1187, 0.2866, 0.4906, 0.501, 0.4038, 0.3091, 0.2301, 0.2458, 0.1595, 0.0853, 0.0382, 0.1966, 0.387, 0.727, 0.5816, 0.5314, 0.3462, 0.2338, 0.0889, 0.0591, 0.0649, 0.0178, 0.0314, 0.1689, 0.284, 0.3122, 0.3332, 0.3321, 0.273, 0.1328, 0.0685, 0.0356, 0.033, 0.0371, 0.1862, 0.3818, 0.4451, 0.4079, 0.3347, 0.2186, 0.137, 0.1396, 0.0633, 0.0497, 0.0141, 0.0262, 0.1276, 0.2197, 0.3321, 0.2814, 0.3243, 0.2537, 0.2296, 0.0973, 0.0298, 0.0188, 0.0073, 0.0502, 0.2479, 0.2986, 0.5434, 0.4215, 0.3326, 0.1966, 0.1365, 0.0743, 0.0303, 0.0873, 0.2317, 0.3342, 0.3609, 0.4069, 0.3394, 0.1867, 0.1109, 0.0581, 0.0298, 0.0455, 0.1888, 0.4168, 0.5983, 0.5732, 0.4644, 0.3546, 0.2484, 0.16, 0.0853, 0.0502, 0.1736, 0.4843, 0.7929, 0.7128, 0.7045, 0.4388, 0.363, 0.1647, 0.0727, 0.023, 0.1987, 0.7411, 0.9947, 0.9665, 0.8316, 0.5873, 0.2819, 0.1961, 0.1459, 0.0534, 0.079, 0.2458, 0.4906, 0.5539, 0.5518, 0.5465, 0.3483, 0.3603, 0.1987, 0.1804, 0.0811, 0.0659, 0.1428, 0.4838, 0.8127};
    public static final int STARTING_YEAR = 1700;
    public static final int WINDOW_SIZE = 30;
    public static final int TRAIN_START = 30;
    public static final int TRAIN_END = 259;
    public static final int EVALUATE_START = 260;
    public static final int EVALUATE_END = SUNSPOTS.length - 1;
    public static final double MAX_ERROR = 0.06;
    private double[] normalizedSunspots;
    private double[] closedLoopSunspots;
    private double mean;

    public void normalizeSunspots(double lo, double hi) {
        int year;
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (year = 0; year < SUNSPOTS.length; ++year) {
            min = Math.min(min, SUNSPOTS[year]);
            max = Math.max(max, SUNSPOTS[year]);
        }
        this.normalizedSunspots = new double[SUNSPOTS.length];
        this.closedLoopSunspots = new double[SUNSPOTS.length];
        this.mean = 0.0;
        for (year = 0; year < SUNSPOTS.length; ++year) {
            this.normalizedSunspots[year] = this.closedLoopSunspots[year] = (SUNSPOTS[year] - min) / (max - min) * (hi - lo) + lo;
            this.mean += this.normalizedSunspots[year] / (double)SUNSPOTS.length;
        }
    }

    public DataSet generateTrainingData() {
        DataSet result = new DataSet(30, 1);
        for (int year = 30; year < 259; ++year) {
            double[] input = new double[30];
            double[] ideal = new double[1];
            int index = 0;
            for (int i = year - 30; i < year; ++i) {
                input[index++] = this.normalizedSunspots[i];
            }
            ideal[0] = this.normalizedSunspots[year];
            result.addRow(new DataSetRow(input, ideal));
        }
        return result;
    }

    public void predict(NeuralNetwork network) {
        NumberFormat f = NumberFormat.getNumberInstance();
        f.setMaximumFractionDigits(4);
        f.setMinimumFractionDigits(4);
        System.out.println("Year\tActual\tPredict\tClosed Loop Predict");
        for (int year = 260; year < EVALUATE_END; ++year) {
            double prediction;
            double[] input = new double[30];
            for (int i = 0; i < input.length; ++i) {
                input[i] = this.normalizedSunspots[year - 30 + i];
            }
            network.setInput(input);
            network.calculate();
            double[] output = network.getOutput();
            this.closedLoopSunspots[year] = prediction = output[0];
            for (int i = 0; i < input.length; ++i) {
                input[i] = this.closedLoopSunspots[year - 30 + i];
            }
            network.setInput(input);
            network.calculate();
            output = network.getOutput();
            double closedLoopPrediction = output[0];
            System.out.println(1700 + year + "\t" + f.format(this.normalizedSunspots[year]) + "\t" + f.format(prediction) + "\t" + f.format(closedLoopPrediction));
        }
    }

    public void run() {
        MultiLayerPerceptron network = new MultiLayerPerceptron(TransferFunctionType.SIGMOID, 30, 10, 1);
        this.normalizeSunspots(0.1, 0.9);
        ((LearningRule)network.getLearningRule()).addListener(this);
        DataSet trainingSet = this.generateTrainingData();
        network.learn(trainingSet);
        this.predict(network);
        Neuroph.getInstance().shutdown();
    }

    public static void main(String[] args) {
        SunSpots sunspot = new SunSpots();
        sunspot.run();
    }

    @Override
    public void handleLearningEvent(LearningEvent event) {
        SupervisedLearning rule = (SupervisedLearning)event.getSource();
        System.out.println("Training, Network Epoch " + rule.getCurrentIteration() + ", Error:" + rule.getTotalNetworkError());
    }
}

