/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.learning;

import java.io.Serializable;
import org.neuroph.core.learning.error.ErrorFunction;

public class CrossEntropyError
implements ErrorFunction,
Serializable {
    private double[] errorDerivative;
    private transient double totalError;
    private transient double n;

    @Override
    public double getTotalError() {
        return -this.totalError / this.n;
    }

    @Override
    public void reset() {
        this.totalError = 0.0;
        this.n = 0.0;
    }

    @Override
    public double[] addPatternError(double[] predictedOutput, double[] targetOutput) {
        double[] error = new double[targetOutput.length];
        if (predictedOutput.length != targetOutput.length) {
            throw new IllegalArgumentException("Output array length and desired output array length must be the same size!");
        }
        for (int i = 0; i < predictedOutput.length; ++i) {
            this.errorDerivative[i] = targetOutput[i] - predictedOutput[i];
            this.totalError += targetOutput[i] * Math.log(predictedOutput[i]);
        }
        this.n += 1.0;
        return error;
    }
}

