/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.graphml;

import org.neuroph.contrib.graphml.Edge;
import org.neuroph.contrib.graphml.Node;
import org.neuroph.contrib.graphml.XMLAttribute;
import org.neuroph.contrib.graphml.XMLElement;
import org.neuroph.core.Connection;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.Neuron;

public class Graph
extends XMLElement {
    public Graph(String id) {
        this.addAttribute(new XMLAttribute("id", id));
        this.addAttribute(new XMLAttribute("edgedefault", "directed"));
    }

    public void addNetwork(NeuralNetwork ann) {
        for (int layer = 0; layer < ann.getLayersCount(); ++layer) {
            for (Neuron neuron : ann.getLayerAt(layer).getNeurons()) {
                this.addNode(neuron);
                this.addEdges(neuron);
            }
        }
    }

    private void addNode(Neuron neuron) {
        this.appendChild(new Node(neuron.getLabel()));
    }

    private void addEdges(Neuron neuron) {
        String source = neuron.getLabel();
        String weightKeyId = "d1";
        for (Connection con : neuron.getOutConnections()) {
            String target = con.getToNeuron().getLabel();
            String weight = String.valueOf(con.getWeight());
            this.appendChild(new Edge(source, target, weightKeyId, weight));
        }
    }

    public static void main(String[] args) {
        Graph graph = new Graph("graph1");
        System.out.println(graph);
    }

    @Override
    public String getTag() {
        return "graph";
    }
}

