/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.adapters.weka;

import java.util.List;
import org.neuroph.adapters.weka.WekaDataSetConverter;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.Neuron;
import org.neuroph.core.data.DataSet;
import weka.classifiers.AbstractClassifier;
import weka.core.Instance;
import weka.core.Instances;

public class WekaNeurophClassifier
extends AbstractClassifier {
    private NeuralNetwork neuralNet;

    public WekaNeurophClassifier(NeuralNetwork neuralNet) {
        this.neuralNet = neuralNet;
    }

    public void buildClassifier(Instances data) throws Exception {
        DataSet dataSet = WekaDataSetConverter.convertWekaToNeurophDataset(data, this.neuralNet.getInputsCount(), this.neuralNet.getOutputsCount());
        this.neuralNet.learn(dataSet);
    }

    public double classifyInstance(Instance instance) throws Exception {
        double[] item = this.convertInstanceToDoubleArray(instance);
        this.neuralNet.setInput(item);
        this.neuralNet.calculate();
        List<Neuron> outputNeurons = this.neuralNet.getOutputNeurons();
        Object maxNeuron = null;
        int maxIdx = 0;
        double maxOut = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < outputNeurons.size(); ++i) {
            if (!(outputNeurons.get(i).getOutput() > maxOut)) continue;
            maxOut = outputNeurons.get(i).getOutput();
            maxIdx = i;
        }
        return maxIdx;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] item = this.convertInstanceToDoubleArray(instance);
        this.neuralNet.setInput(item);
        this.neuralNet.calculate();
        return this.neuralNet.getOutput();
    }

    public NeuralNetwork getNeuralNetwork() {
        return this.neuralNet;
    }

    private double[] convertInstanceToDoubleArray(Instance instance) {
        double[] item = new double[instance.numAttributes() - 1];
        for (int i = 0; i < instance.numAttributes() - 1; ++i) {
            item[i] = instance.value(i);
        }
        return item;
    }
}

