/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;

public class SimpleList<E>
extends AbstractList<E>
implements Serializable {
    private static final long serialVersionUID = -1641584937585415217L;
    private Object[] source;
    private int size;

    public SimpleList(int initialCapacity) {
        this.source = new Object[initialCapacity];
        this.size = 0;
    }

    public SimpleList() {
        this(50);
    }

    public SimpleList(Collection<? extends E> c) {
        this(c.size());
        this.addAll(c);
    }

    @Override
    public E get(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (E)this.source[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void add(int index, E element) {
        if (index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.size == this.source.length) {
            this.source = Arrays.copyOf(this.source, this.size * 2);
        }
        if (index == this.size) {
            this.source[this.size++] = element;
        } else {
            System.arraycopy(this.source, index, this.source, index + 1, this.size - index);
            this.source[index] = element;
            ++this.size;
        }
    }

    @Override
    public E remove(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        Object removed = this.source[index];
        System.arraycopy(this.source, index + 1, this.source, index, this.size - index - 1);
        --this.size;
        return (E)removed;
    }

    @Override
    public E set(int index, E element) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        Object prev = this.source[index];
        this.source[index] = element;
        return (E)prev;
    }
}

