/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PoisonRunnable
implements Runnable {
    private Runnable lastStep;
    private CountDownLatch latch;
    private CyclicBarrier barrier;

    public PoisonRunnable(Runnable lastStep) {
        this.lastStep = lastStep;
    }

    public PoisonRunnable(CountDownLatch latch) {
        this.latch = latch;
    }

    public PoisonRunnable(CyclicBarrier barrier) {
        this.barrier = barrier;
    }

    public PoisonRunnable() {
    }

    @Override
    public void run() {
        try {
            if (this.lastStep != null) {
                this.lastStep.run();
            }
            if (this.latch != null) {
                this.latch.countDown();
            }
            if (this.barrier != null) {
                this.barrier.await();
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger(PoisonRunnable.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (BrokenBarrierException ex) {
            Logger.getLogger(PoisonRunnable.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

