/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import jsat.utils.ClosedHashingUtil;
import jsat.utils.IntDoubleMap;
import jsat.utils.IntList;

public class IntSet
extends AbstractSet<Integer>
implements Serializable {
    private static final long serialVersionUID = -2175363824037596497L;
    private static final int DEFAULT_CAPACITY = 8;
    private float loadFactor;
    private int used = 0;
    private int free = 0;
    private byte[] status;
    private int[] keys;

    public IntSet() {
        this(8);
    }

    public IntSet(int capacity) {
        this(capacity, 0.75f);
    }

    public IntSet(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        int size = ClosedHashingUtil.getNextPow2TwinPrime((int)Math.max((float)capacity / loadFactor, 4.0f));
        this.status = new byte[size];
        this.keys = new int[size];
        this.used = 0;
        this.free = size;
    }

    public IntSet(Set<Integer> set) {
        this(set.size());
        for (Integer integer : set) {
            this.add(integer);
        }
    }

    public IntSet(Collection<Integer> collection) {
        this();
        for (Integer integer : collection) {
            this.add(integer);
        }
    }

    public static IntSet from(int ... ints) {
        return new IntSet(IntList.view(ints, ints.length));
    }

    private long getIndex(int key, boolean inserting) {
        long extraInfo = Long.MIN_VALUE;
        int hash = IntDoubleMap.h(key) & 0xFFFFFFFF;
        int i = hash % this.keys.length;
        byte satus_i = this.status[i];
        if (this.keys[i] == key && satus_i != 2 || satus_i == 0) {
            return extraInfo | (long)i;
        }
        if (extraInfo == Long.MIN_VALUE && satus_i == 2) {
            extraInfo = (long)i << 32;
        }
        int c = 1 + hash % (this.keys.length - 2);
        while (true) {
            if ((i -= c) < 0) {
                i += this.keys.length;
            }
            satus_i = this.status[i];
            if (this.keys[i] == key && satus_i != 2 || satus_i == 0 || satus_i == 2 && inserting) {
                return extraInfo | (long)i;
            }
            if (extraInfo != Long.MIN_VALUE || satus_i != 2) continue;
            extraInfo = (long)i << 32;
        }
    }

    private void enlargeIfNeeded() {
        if ((float)this.used < (float)this.keys.length * this.loadFactor && this.free > 0) {
            return;
        }
        byte[] oldSatus = this.status;
        int[] oldKeys = this.keys;
        int newSize = (float)this.used > (float)this.keys.length * this.loadFactor ? ClosedHashingUtil.getNextPow2TwinPrime(this.status.length * 3 / 2) : oldSatus.length;
        this.status = new byte[newSize];
        this.keys = new int[newSize];
        this.used = 0;
        this.free = newSize;
        for (int oldIndex = 0; oldIndex < oldSatus.length; ++oldIndex) {
            if (oldSatus[oldIndex] != 1) continue;
            this.add(oldKeys[oldIndex]);
        }
    }

    @Override
    public void clear() {
        this.used = 0;
        Arrays.fill(this.status, (byte)0);
    }

    @Override
    public boolean add(Integer e) {
        if (e == null) {
            return false;
        }
        return this.add((int)e);
    }

    @Override
    public boolean add(int e) {
        int key = e;
        long pair_index = this.getIndex(key, true);
        int deletedIndex = (int)(pair_index >>> 32);
        int valOrFreeIndex = (int)(pair_index & 0xFFFFFFFFFFFFFFFFL);
        byte origStatus = this.status[valOrFreeIndex];
        if (origStatus == 1) {
            return false;
        }
        int i = valOrFreeIndex;
        if (deletedIndex >= 0) {
            i = deletedIndex;
            origStatus = this.status[i];
        }
        this.status[i] = 1;
        this.keys[i] = key;
        ++this.used;
        if (origStatus == 0) {
            --this.free;
        }
        this.enlargeIfNeeded();
        return true;
    }

    public boolean contains(int o) {
        int index = (int)(this.getIndex(o, false) & 0xFFFFFFFFFFFFFFFFL);
        return this.status[index] == 1;
    }

    @Override
    public boolean remove(Object key) {
        if (key instanceof Integer) {
            return this.remove((Integer)key);
        }
        return false;
    }

    public boolean remove(int key) {
        long pair_index = this.getIndex(key, false);
        int valOrFreeIndex = (int)(pair_index & 0xFFFFFFFFFFFFFFFFL);
        if (this.status[valOrFreeIndex] == 0) {
            return false;
        }
        this.status[valOrFreeIndex] = 2;
        --this.used;
        return true;
    }

    @Override
    public boolean contains(Object o) {
        if (o != null && o instanceof Integer) {
            return this.contains((Integer)o);
        }
        return false;
    }

    @Override
    public Iterator<Integer> iterator() {
        int START;
        final IntSet parentRef = this;
        for (START = 0; START < this.status.length && this.status[START] != 1; ++START) {
        }
        if (START == this.status.length) {
            return Collections.emptyIterator();
        }
        final int startPos = START;
        return new Iterator<Integer>(){
            int pos;
            int prevPos;
            {
                this.pos = startPos;
                this.prevPos = -1;
            }

            @Override
            public boolean hasNext() {
                return this.pos < IntSet.this.status.length;
            }

            @Override
            public Integer next() {
                this.prevPos = this.pos++;
                int oldPos = this.prevPos;
                while (this.pos < IntSet.this.status.length && IntSet.this.status[this.pos] != 1) {
                    ++this.pos;
                }
                return IntSet.this.keys[oldPos];
            }

            @Override
            public void remove() {
                parentRef.remove(IntSet.this.keys[this.prevPos]);
            }
        };
    }

    @Override
    public int size() {
        return this.used;
    }
}

