/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FibHeap<T> {
    FibNode<T> min = null;
    int n = 0;
    List<FibNode<T>> H;

    public int size() {
        return this.n;
    }

    public FibNode<T> insert(T value, double weight) {
        FibNode<T> x = new FibNode<T>(value, weight);
        x.p = null;
        x.child = null;
        this.min = this.min == null ? x : FibHeap.merge(this.min, x);
        ++this.n;
        return x;
    }

    public static <T> FibHeap<T> union(FibHeap<T> A, FibHeap<T> B) {
        FibHeap<T> H = new FibHeap<T>();
        H.min = FibHeap.merge(A.min, B.min);
        H.n = A.n + B.n;
        return H;
    }

    private void consolidate() {
        FibNode<T> startingNode;
        ArrayList<FibNode> A = new ArrayList<FibNode>();
        ArrayList<FibNode<T>> rootListCopy = new ArrayList<FibNode<T>>();
        FibNode<T> runner = startingNode = this.min;
        do {
            rootListCopy.add(runner);
        } while ((runner = runner.right) != startingNode);
        for (FibNode fibNode : rootListCopy) {
            FibHeap.delink(fibNode);
        }
        Iterator iterator = rootListCopy.iterator();
        while (iterator.hasNext()) {
            FibNode fibNode;
            FibNode x = fibNode = (FibNode)iterator.next();
            int d = x.degree;
            while (A.size() <= d) {
                A.add(null);
            }
            while (A.get(d) != null) {
                FibNode y = (FibNode)A.get(d);
                if (x.key > y.key) {
                    FibNode tmp = y;
                    y = x;
                    x = tmp;
                }
                this.link(y, x);
                A.set(d, null);
                ++d;
                while (A.size() <= d) {
                    A.add(null);
                }
            }
            A.set(d, x);
        }
        this.min = null;
        for (FibNode fibNode : A) {
            this.min = FibHeap.merge(this.min, fibNode);
        }
    }

    private void link(FibNode<T> y, FibNode<T> x) {
        FibHeap.delink(y);
        x.addChild(y);
        ++x.degree;
        x.degree += y.degree;
        y.mark = false;
    }

    public double getMinKey() {
        return this.min.key;
    }

    public T getMinValue() {
        return this.min.value;
    }

    public FibNode<T> peekMin() {
        return this.min;
    }

    public FibNode<T> removeMin() {
        FibNode<T> z = this.min;
        if (z != null) {
            this.min = FibHeap.delink(z);
            if (z.child != null) {
                FibNode startingNode;
                FibNode x = startingNode = z.child;
                do {
                    x.p = null;
                } while ((x = x.right) != startingNode);
                this.min = FibHeap.merge(this.min, z.child);
                z.child = null;
                z.degree = 0;
            } else if (this.n == 1) {
                this.min = null;
            }
            if (this.min != null) {
                this.consolidate();
            }
            --this.n;
        }
        return z;
    }

    public void decreaseKey(FibNode<T> x, double k) {
        if (k > x.key) {
            throw new RuntimeException("new key is greater than current key");
        }
        x.key = k;
        FibNode y = x.p;
        if (y != null && x.key < y.key) {
            this.cut(x, y);
            this.cascadingCut(y);
        }
        if (x.key < this.min.key) {
            this.min = x;
        }
    }

    private void cut(FibNode<T> x, FibNode<T> y) {
        if (y.child == x) {
            y.child = FibHeap.delink(x);
        } else {
            FibHeap.delink(x);
        }
        --y.degree;
        y.degree -= x.degree;
        this.min = FibHeap.merge(this.min, x);
        x.p = null;
        x.mark = false;
    }

    private void cascadingCut(FibNode<T> y) {
        FibNode z = y.p;
        if (z != null) {
            if (!y.mark) {
                y.mark = true;
            } else {
                this.cut(y, z);
                this.cascadingCut(z);
            }
        }
    }

    private static <T> FibNode<T> delink(FibNode<T> a) {
        if (a.left == a) {
            return null;
        }
        FibNode a_left_orig = a.left;
        a.left.right = a.right;
        a.right.left = a_left_orig;
        a.right = a;
        a.left = a.right;
        return a_left_orig;
    }

    private static <T> FibNode<T> merge(FibNode<T> a, FibNode<T> b) {
        if (a == b) {
            return a;
        }
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.key > b.key) {
            FibNode<T> tmp = a;
            a = b;
            b = tmp;
        }
        FibNode a_right_orig = a.right;
        a.right = b.right;
        a.right.left = a;
        b.right = a_right_orig;
        b.right.left = b;
        return a;
    }

    public static class FibNode<T> {
        T value;
        double key;
        int degree = 0;
        boolean mark = false;
        FibNode<T> p;
        FibNode<T> child;
        FibNode<T> left;
        FibNode<T> right;

        public FibNode(T value, double key) {
            this.value = value;
            this.key = key;
            this.left = this.right = this;
        }

        public T getValue() {
            return this.value;
        }

        public double getPriority() {
            return this.key;
        }

        public void addChild(FibNode<T> x) {
            this.child = this.child == null ? x : FibHeap.merge(this.child, x);
            x.p = this;
        }

        public String toString() {
            return this.value + "," + this.key;
        }
    }
}

